/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.servlet.artemis;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.eclipse.hawk.core.IStateListener;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.service.api.HawkState;
import org.eclipse.hawk.service.api.HawkStateEvent;
import org.eclipse.hawk.service.api.utils.APIUtils;
import org.eclipse.hawk.service.api.utils.ActiveMQBufferTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisProducerStateListener
implements IStateListener {
    private final HModel model;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtemisProducerStateListener.class);
    private final ServerLocator locator;
    private final ClientSessionFactory sessionFactory;
    private final String queueAddress;
    private final TProtocolFactory protocolFactory;
    private ThreadLocal<ClientState> clientState = new ThreadLocal<ClientState>(){

        @Override
        protected ClientState initialValue() {
            return new ClientState();
        }
    };

    public ArtemisProducerStateListener(HModel model, String queueAddress) throws Exception {
        this.model = model;
        this.queueAddress = queueAddress;
        this.locator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName())});
        this.sessionFactory = this.locator.createSessionFactory();
        this.protocolFactory = APIUtils.ThriftProtocol.JSON.getProtocolFactory();
    }

    public void state(IStateListener.HawkState state) {
        this.sendState();
    }

    public void info(String s) {
        this.sendState();
    }

    public void error(String s) {
        this.sendState();
    }

    private void sendState() {
        this.openSession();
        HawkStateEvent ev = new HawkStateEvent();
        ev.setTimestamp(System.currentTimeMillis());
        ev.setMessage(this.model.getInfo());
        ev.setState(ArtemisProducerStateListener.mapHawkStateToThrift(this.model.getStatus()));
        this.sendEvent(ev);
    }

    private void sendEvent(HawkStateEvent change) {
        try {
            ClientMessage msg = this.clientState.get().session.createMessage((byte)4, false);
            ActiveMQBufferTransport trans = new ActiveMQBufferTransport(msg.getBodyBuffer());
            TProtocol proto = this.protocolFactory.getProtocol((TTransport)trans);
            change.write(proto);
            this.clientState.get().producer.send((Message)msg);
        }
        catch (TException ex) {
            LOGGER.error("Serialization error", (Throwable)ex);
        }
        catch (ActiveMQException ex) {
            LOGGER.error("Error while sending event", (Throwable)ex);
        }
    }

    private void openSession() {
        ClientState state = this.clientState.get();
        if (state.session == null || state.session.isClosed()) {
            try {
                state.session = this.sessionFactory.createSession();
                state.producer = state.session.createProducer(this.queueAddress);
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not start a new Artemis session", (Throwable)e);
            }
        }
    }

    private void closeSession() {
        ClientState state = this.clientState.get();
        try {
            try {
                if (state.producer != null) {
                    state.producer.close();
                }
                if (state.session != null) {
                    state.session.close();
                }
            }
            catch (ActiveMQException e) {
                LOGGER.error("Could not close the session", (Throwable)e);
                state.session = null;
            }
        }
        finally {
            state.session = null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtemisProducerStateListener other = (ArtemisProducerStateListener)obj;
        return !(this.model == null ? other.model != null : !this.model.equals(other.model));
    }

    public void removed() {
        this.closeSession();
    }

    public static HawkState mapHawkStateToThrift(IStateListener.HawkState state) {
        switch (state) {
            case RUNNING: {
                return HawkState.RUNNING;
            }
            case UPDATING: {
                return HawkState.UPDATING;
            }
        }
        return HawkState.STOPPED;
    }

    public static IStateListener.HawkState mapThriftStateToHawk(HawkState state) {
        switch (state) {
            case RUNNING: {
                return IStateListener.HawkState.RUNNING;
            }
            case UPDATING: {
                return IStateListener.HawkState.UPDATING;
            }
        }
        return IStateListener.HawkState.STOPPED;
    }

    protected final class ClientState {
        protected ClientSession session;
        protected ClientProducer producer;

        protected ClientState() {
        }
    }
}

