/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.SVNPropertyValue;

public class SVNProperty {
    public static final String SVN_PREFIX = "svn:";
    public static final String SVNKIT_PREFIX = "svnkit:";
    public static final String SVN_WC_PREFIX = "svn:wc:";
    public static final String SVN_SYNC_PREFIX = "svn:sync-";
    public static final String TXN_CHECK_LOCKS = "svn:check-locks";
    public static final String TXN_CHECK_OUT_OF_DATENESS = "svn:check-ood";
    public static final String SVN_ENTRY_PREFIX = "svn:entry:";
    public static final String SVNKIT_ENTRY_PREFIX = "svnkit:entry:";
    public static final String EOL_STYLE = "svn:eol-style";
    public static final String IGNORE = "svn:ignore";
    public static final String MIME_TYPE = "svn:mime-type";
    public static final String KEYWORDS = "svn:keywords";
    public static final String EXECUTABLE = "svn:executable";
    public static final String EXTERNALS = "svn:externals";
    public static final String SPECIAL = "svn:special";
    public static final String MERGE_INFO = "svn:mergeinfo";
    public static final String INHERITABLE_IGNORES = "svn:global-ignores";
    public static final String INHERITABLE_AUTO_PROPS = "svn:auto-props";
    public static final String REVISION = "svn:entry:revision";
    public static final String COMMITTED_REVISION = "svn:entry:committed-rev";
    public static final String COMMITTED_DATE = "svn:entry:committed-date";
    public static final String HAS_PROPS = "svn:entry:has-props";
    public static final String HAS_PROP_MODS = "svn:entry:has-prop-mods";
    public static final String CACHABLE_PROPS = "svn:entry:cachable-props";
    public static final String PRESENT_PROPS = "svn:entry:present-props";
    public static final String KEEP_LOCAL = "svn:entry:keep-local";
    public static final String CHANGELIST = "svn:entry:changelist";
    public static final String WORKING_SIZE = "svn:entry:working-size";
    public static final String DEPTH = "svn:entry:depth";
    public static final String FILE_EXTERNAL_PATH = "svn:entry:file-external-path";
    public static final String FILE_EXTERNAL_REVISION = "svn:entry:file-external-revision";
    public static final String FILE_EXTERNAL_PEG_REVISION = "svn:entry:file-external-peg-revision";
    public static final String TREE_CONFLICT_DATA = "svn:entry:tree-conflicts";
    public static final String CHECKSUM = "svn:entry:checksum";
    public static final String SVNKIT_SHA1_CHECKSUM = "svnkit:entry:sha1-checksum";
    public static final String URL = "svn:entry:url";
    public static final String COPYFROM_URL = "svn:entry:copyfrom-url";
    public static final String COPYFROM_REVISION = "svn:entry:copyfrom-rev";
    public static final String SCHEDULE = "svn:entry:schedule";
    public static final String COPIED = "svn:entry:copied";
    public static final String LAST_AUTHOR = "svn:entry:last-author";
    public static final String UUID = "svn:entry:uuid";
    public static final String REPOS = "svn:entry:repos";
    public static final String PROP_TIME = "svn:entry:prop-time";
    public static final String TEXT_TIME = "svn:entry:text-time";
    public static final String NAME = "svn:entry:name";
    public static final String KIND = "svn:entry:kind";
    public static final String CONFLICT_OLD = "svn:entry:conflict-old";
    public static final String CONFLICT_NEW = "svn:entry:conflict-new";
    public static final String CONFLICT_WRK = "svn:entry:conflict-wrk";
    public static final String PROP_REJECT_FILE = "svn:entry:prop-reject-file";
    public static final String DELETED = "svn:entry:deleted";
    public static final String ABSENT = "svn:entry:absent";
    public static final String INCOMPLETE = "svn:entry:incomplete";
    public static final String CORRUPTED = "svn:entry:corrupted";
    public static final String WC_URL = "svn:wc:ra_dav:version-url";
    public static final String ACTIVITY_URL = "svn:wc:ra_dav:activity-url";
    public static final String LOCK_TOKEN = "svn:entry:lock-token";
    public static final String LOCK_COMMENT = "svn:entry:lock-comment";
    public static final String LOCK_OWNER = "svn:entry:lock-owner";
    public static final String LOCK_CREATION_DATE = "svn:entry:lock-creation-date";
    public static final String NEEDS_LOCK = "svn:needs-lock";
    public static final String KIND_DIR = "dir";
    public static final String KIND_FILE = "file";
    public static final String EOL_STYLE_LF = "LF";
    public static final String EOL_STYLE_CR = "CR";
    public static final String EOL_STYLE_CRLF = "CRLF";
    public static final String EOL_STYLE_NATIVE = "native";
    public static final byte[] EOL_LF_BYTES = new byte[]{10};
    public static final byte[] EOL_CRLF_BYTES = new byte[]{13, 10};
    public static final byte[] EOL_CR_BYTES = new byte[]{13};
    public static final String CHARSET = "svnkit:charset";
    public static final String NATIVE = "native";
    public static final String SCHEDULE_ADD = "add";
    public static final String SCHEDULE_DELETE = "delete";
    public static final String SCHEDULE_REPLACE = "replace";
    public static final long WORKING_SIZE_UNKNOWN = -1L;
    public static final SVNPropertyValue BOOLEAN_PROPERTY_VALUE = SVNPropertyValue.create("*");
    private static final Set ourTextMimeTypes = new HashSet();

    public static boolean isWorkingCopyProperty(String name) {
        return name != null && name.startsWith(SVN_WC_PREFIX);
    }

    public static boolean isEntryProperty(String name) {
        return name != null && (name.startsWith(SVN_ENTRY_PREFIX) || name.startsWith(SVNKIT_ENTRY_PREFIX));
    }

    public static boolean isSVNProperty(String name) {
        return name != null && (name.startsWith(SVN_PREFIX) || name.startsWith(SVNKIT_PREFIX));
    }

    public static boolean isSVNKitProperty(String name) {
        return name != null && name.startsWith(SVNKIT_PREFIX);
    }

    public static boolean isRegularProperty(String name) {
        if (name == null) {
            return false;
        }
        return !SVNProperty.isWorkingCopyProperty(name) && !SVNProperty.isEntryProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTextMimeType(String mimeType) {
        if (mimeType == null || mimeType.startsWith("text/")) {
            return true;
        }
        Set set = ourTextMimeTypes;
        synchronized (set) {
            return ourTextMimeTypes.contains(mimeType);
        }
    }

    public static boolean isBinaryMimeType(String mimeType) {
        return !SVNProperty.isTextMimeType(mimeType);
    }

    public static boolean isUTF8(String charset) {
        return charset != null && charset.equalsIgnoreCase("UTF-8");
    }

    public static boolean booleanValue(String text) {
        return text == null ? false : Boolean.valueOf(text.trim());
    }

    public static long longValue(String text) {
        if (text != null) {
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static String toString(boolean b) {
        return Boolean.toString(b);
    }

    public static String toString(long i) {
        return Long.toString(i);
    }

    public static String shortPropertyName(String longName) {
        if (longName == null) {
            return null;
        }
        if (longName.startsWith(SVN_ENTRY_PREFIX)) {
            return longName.substring(SVN_ENTRY_PREFIX.length());
        }
        if (longName.startsWith(SVN_WC_PREFIX)) {
            return longName.substring(SVN_WC_PREFIX.length());
        }
        if (longName.startsWith(SVN_PREFIX)) {
            return longName.substring(SVN_PREFIX.length());
        }
        return longName;
    }

    public static SVNPropertyValue getValueOfBooleanProperty(String propName) {
        if (EXECUTABLE.equals(propName) || NEEDS_LOCK.equals(propName) || SPECIAL.equals(propName)) {
            return BOOLEAN_PROPERTY_VALUE;
        }
        return null;
    }

    public static boolean isBooleanProperty(String propName) {
        return EXECUTABLE.equals(propName) || SPECIAL.equals(propName) || NEEDS_LOCK.equals(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTextMimeType(String textMimeType) {
        if (textMimeType != null) {
            Set set = ourTextMimeTypes;
            synchronized (set) {
                ourTextMimeTypes.add(textMimeType);
            }
        }
    }

    public static boolean mimeTypeIsBinary(String mimeType) {
        int len = mimeType.indexOf(59);
        if (len == -1) {
            len = mimeType.indexOf(32);
        }
        return !"text/".equals(mimeType.substring(0, 5)) && (len != 15 || "image/x-xbitmap".equals(mimeType.substring(0, len)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTextMimeTypes() {
        Set set = ourTextMimeTypes;
        synchronized (set) {
            return new HashSet(ourTextMimeTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTextMimeTypes() {
        Set set = ourTextMimeTypes;
        synchronized (set) {
            ourTextMimeTypes.clear();
        }
    }
}

