/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client;

import org.eclipse.hono.client.ServiceInvocationException;

public class ServerErrorException
extends ServiceInvocationException {
    private static final long serialVersionUID = 1L;
    private String clientFacingMessage;

    public ServerErrorException(int errorCode) {
        this(null, errorCode, null, null);
    }

    public ServerErrorException(String tenant, int errorCode) {
        this(tenant, errorCode, null, null);
    }

    public ServerErrorException(int errorCode, String msg) {
        this(null, errorCode, msg, null);
    }

    public ServerErrorException(String tenant, int errorCode, String msg) {
        this(tenant, errorCode, msg, null);
    }

    public ServerErrorException(int errorCode, Throwable cause) {
        this(null, errorCode, null, cause);
    }

    public ServerErrorException(String tenant, int errorCode, Throwable cause) {
        this(tenant, errorCode, null, cause);
    }

    public ServerErrorException(int errorCode, String msg, Throwable cause) {
        this(null, errorCode, msg, cause);
    }

    public ServerErrorException(String tenant, int errorCode, String msg, Throwable cause) {
        super(tenant, errorCode, msg, cause);
        if (errorCode < 500 || errorCode >= 600) {
            throw new IllegalArgumentException("client error code must be >= 500 and < 600");
        }
    }

    public final String getClientFacingMessage() {
        return this.clientFacingMessage;
    }

    public final void setClientFacingMessageWithKey(String clientFacingMessageKey) {
        this.clientFacingMessage = ServerErrorException.getLocalizedMessage(clientFacingMessageKey);
    }
}

