/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import org.apache.qpid.proton.amqp.transport.DeliveryState;

public interface SendMessageSampler {
    public static SendMessageSampler noop() {
        return Noop.SAMPLER;
    }

    public Sample start(String var1);

    public void noCredit(String var1);

    public static class Noop {
        private static final Sample SAMPLE = new Sample(){

            @Override
            public void completed(String outcome) {
            }

            @Override
            public void timeout() {
            }
        };
        private static final SendMessageSampler SAMPLER = new SendMessageSampler(){

            @Override
            public Sample start(String tenantId) {
                return SAMPLE;
            }

            @Override
            public void noCredit(String tenantId) {
            }
        };
        private static final Factory FACTORY = new Factory(){

            @Override
            public SendMessageSampler create(String messageType) {
                return SAMPLER;
            }
        };

        private Noop() {
        }
    }

    public static interface Sample {
        public static final String OUTCOME_ABORTED = "aborted";

        public void completed(String var1);

        default public void completed(DeliveryState remoteState) {
            if (remoteState == null) {
                this.completed(OUTCOME_ABORTED);
            } else {
                this.completed(remoteState.getClass().getSimpleName().toLowerCase());
            }
        }

        public void timeout();
    }

    public static interface Factory {
        public SendMessageSampler create(String var1);

        public static Factory noop() {
            return Noop.FACTORY;
        }
    }
}

