/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.util.Strings;

public final class IdentityTemplate {
    private static final String QUOTED_PLACEHOLDER_SUBJECT_DN = Pattern.quote("{{subject-dn}}");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{(.*?)\\}\\}");
    private static final List<String> SUPPORTED_PLACE_HOLDERS = new ArrayList<String>();
    private final String template;

    public IdentityTemplate(String template) {
        IdentityTemplate.checkValidity(template);
        this.template = template;
    }

    public String apply(String subjectDN) {
        Objects.requireNonNull(subjectDN, "subjectDN must not be null");
        try {
            List<Rdn> rdns = new LdapName(subjectDN).getRdns();
            String result = this.template.replaceAll(QUOTED_PLACEHOLDER_SUBJECT_DN, new X500Principal(subjectDN).getName("RFC2253"));
            for (Attribute attribute : Attribute.values()) {
                result = IdentityTemplate.applyAttribute(attribute, result, rdns);
            }
            return result;
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(String.format("subject DN [%s] is not valid", subjectDN));
        }
    }

    public static void checkValidity(String template) {
        Objects.requireNonNull(template, "template must not be null");
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(template);
        ArrayList<String> placeholders = new ArrayList<String>();
        while (matcher.find()) {
            placeholders.add(String.format("{{%s}}", matcher.group(1)));
        }
        if (placeholders.isEmpty()) {
            throw new IllegalArgumentException(String.format("template [%s] must contain at least one placeholder", template));
        }
        List unsupportedPlaceHolders = placeholders.stream().filter(placeholder -> !SUPPORTED_PLACE_HOLDERS.contains(placeholder)).collect(Collectors.toList());
        if (!unsupportedPlaceHolders.isEmpty()) {
            throw new IllegalArgumentException(String.format("template [%s] contains unsupported placeholders %s", template, unsupportedPlaceHolders));
        }
    }

    public String toString() {
        return this.template;
    }

    private static String applyAttribute(Attribute attribute, String template, List<Rdn> rdns) {
        if (template.contains(attribute.getPlaceHolder())) {
            String attributeValue = attribute.getValue(rdns);
            if (Strings.isNullOrEmpty(attributeValue)) {
                throw new IllegalArgumentException(String.format("error filling template [%s] as [%s] is missing in client certificate's Subject DN", template, attribute.getName()));
            }
            return template.replaceAll(Pattern.quote(attribute.getPlaceHolder()), attributeValue);
        }
        return template;
    }

    static {
        SUPPORTED_PLACE_HOLDERS.add("{{subject-dn}}");
        Arrays.stream(Attribute.values()).map(Attribute::getPlaceHolder).forEach(SUPPORTED_PLACE_HOLDERS::add);
    }

    private static enum Attribute {
        CN("Common Name", "{{subject-cn}}"),
        OU("Organizational Unit Name", "{{subject-ou}}"),
        O("Organization Name", "{{subject-o}}");

        private final String name;
        private final String placeHolder;

        private Attribute(String name, String placeHolder) {
            Objects.requireNonNull(name, "attribute name must not be null");
            Objects.requireNonNull(placeHolder, "attribute placeholder must not be null");
            this.name = name;
            this.placeHolder = placeHolder;
        }

        String getName() {
            return this.name;
        }

        String getPlaceHolder() {
            return this.placeHolder;
        }

        String getValue(List<Rdn> rdns) {
            Objects.requireNonNull(rdns, "rdns list must not be null");
            return rdns.stream().filter(rdn -> this.toString().equalsIgnoreCase(rdn.getType())).findFirst().map(Rdn::getValue).filter(String.class::isInstance).map(String.class::cast).orElse(null);
        }
    }
}

