/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.time.Duration;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

public class IntervalMulti
extends AbstractMulti<Long> {
    private final ScheduledExecutorService executor;
    private final Duration initialDelay;
    private final Duration period;

    public IntervalMulti(Duration initialDelay, Duration period, ScheduledExecutorService executor) {
        this.initialDelay = ParameterValidation.validate(initialDelay, "initialDelay");
        this.period = ParameterValidation.validate(period, "period");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    public IntervalMulti(Duration period, ScheduledExecutorService executor) {
        this.initialDelay = null;
        this.period = ParameterValidation.validate(period, "period");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    public void subscribe(MultiSubscriber<? super Long> actual) {
        IntervalRunnable runnable = new IntervalRunnable(actual, this.period, this.initialDelay, this.executor);
        actual.onSubscribe(runnable);
    }

    static final class IntervalRunnable
    implements Runnable,
    Subscription {
        private final MultiSubscriber<? super Long> actual;
        private final AtomicLong requested = new AtomicLong();
        private final Duration period;
        private final Duration initialDelay;
        private final ScheduledExecutorService executor;
        private volatile boolean cancelled;
        private volatile boolean once = true;
        private final AtomicLong count = new AtomicLong();
        private ScheduledFuture<?> future;

        IntervalRunnable(MultiSubscriber<? super Long> actual, Duration period, Duration initial, ScheduledExecutorService executor) {
            this.actual = actual;
            this.period = period;
            this.initialDelay = initial;
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            block5: {
                try {
                    IntervalRunnable intervalRunnable = this;
                    synchronized (intervalRunnable) {
                        this.future = this.initialDelay != null ? this.executor.scheduleAtFixedRate(this, this.initialDelay.toMillis(), this.period.toMillis(), TimeUnit.MILLISECONDS) : this.executor.scheduleAtFixedRate(this, 0L, this.period.toMillis(), TimeUnit.MILLISECONDS);
                    }
                }
                catch (RejectedExecutionException ree) {
                    if (this.cancelled) break block5;
                    this.actual.onFailure(new RejectedExecutionException(ree));
                }
            }
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                if (this.requested.get() != 0L) {
                    this.actual.onItem((Long)this.count.getAndIncrement());
                    if (this.requested.get() != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                } else {
                    this.cancel();
                    this.actual.onFailure(new BackPressureFailure("Could not emit tick " + this.count + " due to lack of requests"));
                }
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
            }
            if (this.once) {
                this.start();
                this.once = false;
            }
        }

        @Override
        public synchronized void cancel() {
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(false);
            }
        }
    }
}

