/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import io.vertx.codegen.CodeGen;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Generator;
import io.vertx.codegen.GeneratorLoader;
import io.vertx.codegen.Helper;
import io.vertx.codegen.Model;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.generators.dataobjecthelper.DataObjectHelperGenLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"codegen.output", "codegen.generators"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class CodeGenProcessor
extends AbstractProcessor {
    private static final int JAVA = 0;
    private static final int RESOURCE = 1;
    private static final int OTHER = 2;
    private static final String JSON_MAPPERS_PROPERTIES_PATH = "META-INF/vertx/json-mappers.properties";
    public static final Logger log = Logger.getLogger(CodeGenProcessor.class.getName());
    private File outputDirectory;
    private List<? extends Generator<?>> codeGenerators;
    private Map<String, GeneratedFile> generatedFiles = new HashMap<String, GeneratedFile>();
    private Map<String, GeneratedFile> generatedResources = new HashMap<String, GeneratedFile>();
    private Map<String, String> relocations = new HashMap<String, String>();
    private Set<Class<? extends Annotation>> supportedAnnotation = new HashSet<Class<? extends Annotation>>();
    private List<CodeGen.Converter> mappers;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotation.stream().map(Class::getName).collect(Collectors.toSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.generatedFiles.clear();
        this.generatedResources.clear();
        this.supportedAnnotation = new HashSet<Class>(Arrays.asList(DataObject.class, VertxGen.class));
        this.getCodeGenerators().stream().flatMap(gen -> gen.annotations().stream()).forEach(this.supportedAnnotation::add);
        if (this.mappers == null) {
            this.mappers = this.loadJsonMappers();
        }
    }

    private Predicate<Generator> filterGenerators() {
        String generatorsOption = this.processingEnv.getOptions().get("codegen.generators");
        if (generatorsOption != null) {
            List wanted = Stream.of(generatorsOption.split(",")).map(String::trim).map(Pattern::compile).collect(Collectors.toList());
            return cg -> wanted.stream().anyMatch(p -> p.matcher(cg.name).matches());
        }
        return null;
    }

    private Collection<? extends Generator<?>> getCodeGenerators() {
        if (this.codeGenerators == null) {
            String outputDirectoryOption = this.processingEnv.getOptions().get("codegen.output");
            if (outputDirectoryOption != null) {
                this.outputDirectory = new File(outputDirectoryOption);
                if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " does not exist");
                }
                if (!this.outputDirectory.isDirectory()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Output directory " + outputDirectoryOption + " is not a directory");
                }
            }
            Stream serviceLoader = StreamSupport.stream(ServiceLoader.load(GeneratorLoader.class, CodeGenProcessor.class.getClassLoader()).spliterator(), false);
            Stream<DataObjectHelperGenLoader> loaders = Stream.of(new DataObjectHelperGenLoader());
            Stream<Object> generators = Stream.concat(serviceLoader, loaders).flatMap(l -> l.loadGenerators(this.processingEnv));
            Predicate<Generator> filter = this.filterGenerators();
            if (filter != null) {
                generators = generators.filter(filter);
            }
            generators = generators.peek(gen -> {
                gen.load(this.processingEnv);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded " + gen.name + " code generator");
            });
            this.relocations = this.processingEnv.getOptions().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("codegen.output.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("codegen.output.".length()), Map.Entry::getValue));
            this.codeGenerators = generators.collect(Collectors.toList());
        }
        return this.codeGenerators;
    }

    private static void loadJsonMappers(List<CodeGen.Converter> list, InputStream is) throws IOException {
        Properties tmp = new Properties();
        tmp.load(is);
        tmp.stringPropertyNames().forEach(name -> {
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                String type = name.substring(0, idx);
                String value = tmp.getProperty((String)name);
                int idx1 = value.indexOf(35);
                if (idx1 != -1) {
                    String className = value.substring(0, idx1);
                    String rest = value.substring(idx1 + 1);
                    int idx2 = rest.indexOf(46);
                    if (idx2 != -1) {
                        list.add(new CodeGen.Converter(type, className, Arrays.asList(rest.substring(0, idx2), rest.substring(idx2 + 1))));
                    } else {
                        list.add(new CodeGen.Converter(type, className, Collections.singletonList(rest)));
                    }
                }
            }
        });
    }

    private Path determineSourcePathInEclipse() {
        try {
            Filer filer = this.processingEnv.getFiler();
            if (!filer.getClass().getName().startsWith("com.sun.tools.javac")) {
                JavaFileObject generationForPath = filer.createClassFile("PathFor" + this.getClass().getSimpleName(), new Element[0]);
                return new File(generationForPath.toUri()).toPath().getParent();
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to determine source file path!");
        }
        return null;
    }

    private List<CodeGen.Converter> loadJsonMappers() {
        Path source;
        Path path;
        Throwable throwable;
        Exception exception = null;
        ArrayList<CodeGen.Converter> merged = new ArrayList<CodeGen.Converter>();
        for (StandardLocation loc : StandardLocation.values()) {
            try {
                FileObject file = this.processingEnv.getFiler().getResource(loc, "", JSON_MAPPERS_PROPERTIES_PATH);
                try (InputStream is = file.openInputStream();){
                    try {
                        CodeGenProcessor.loadJsonMappers(merged, is);
                        exception = null;
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                }
            }
            catch (Exception ignore) {
                exception = ignore;
            }
        }
        if (exception != null) {
            try {
                Enumeration<URL> resources = this.getClass().getClassLoader().getResources(JSON_MAPPERS_PROPERTIES_PATH);
                while (resources.hasMoreElements()) {
                    URL url = resources.nextElement();
                    InputStream is = url.openStream();
                    throwable = null;
                    try {
                        CodeGenProcessor.loadJsonMappers(merged, is);
                        exception = null;
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded json-mappers.properties " + url);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception != null && (path = this.determineSourcePathInEclipse()) != null && (source = path.getParent().getParent().resolve("src/main/resources").resolve(JSON_MAPPERS_PROPERTIES_PATH)).toFile().exists()) {
            try {
                throwable = null;
                try (InputStream is = source.toUri().toURL().openStream();){
                    CodeGenProcessor.loadJsonMappers(merged, is);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Loaded json-mappers.properties from '" + source + "'");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not load json-mappers.properties", e);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unable to open properties file at " + source);
            }
        }
        return merged;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            Collection<? extends Generator<?>> codeGenerators = this.getCodeGenerators();
            if (!roundEnv.errorRaised()) {
                CodeGen codegen = new CodeGen(this.processingEnv);
                this.mappers.forEach(codegen::registerConverter);
                codegen.init(roundEnv, this.getClass().getClassLoader());
                HashMap generatedClasses = new HashMap();
                codegen.getModels().forEach(entry -> {
                    try {
                        Model model = (Model)entry.getValue();
                        for (Generator codeGenerator : codeGenerators) {
                            List processings;
                            int kind;
                            String relativeName;
                            if (!codeGenerator.kinds.contains(model.getKind()) || (relativeName = codeGenerator.filename(model)) == null) continue;
                            if (relativeName.endsWith(".java") && !relativeName.contains("/")) {
                                String relocation = this.relocations.get(codeGenerator.name);
                                if (relocation != null) {
                                    kind = 2;
                                    relativeName = relocation + '/' + relativeName.substring(0, relativeName.length() - ".java".length()).replace('.', '/') + ".java";
                                } else {
                                    kind = 0;
                                }
                            } else {
                                kind = relativeName.startsWith("resources/") ? 1 : 2;
                            }
                            if (kind == 0) {
                                String fqn = relativeName.substring(0, relativeName.length() - ".java".length());
                                if (this.processingEnv.getElementUtils().getTypeElement(fqn) != null) continue;
                                List processings2 = generatedClasses.computeIfAbsent(fqn, GeneratedFile::new);
                                processings2.add(new ModelProcessing(model, codeGenerator));
                                continue;
                            }
                            if (kind == 1) {
                                relativeName = relativeName.substring("resources/".length());
                                processings = this.generatedResources.computeIfAbsent(relativeName, GeneratedFile::new);
                                processings.add(new ModelProcessing(model, codeGenerator));
                                continue;
                            }
                            processings = this.generatedFiles.computeIfAbsent(relativeName, GeneratedFile::new);
                            processings.add(new ModelProcessing(model, codeGenerator));
                        }
                    }
                    catch (GenException e) {
                        this.reportGenException(e);
                    }
                    catch (Exception e) {
                        this.reportException(e, (Element)entry.getKey());
                    }
                });
                generatedClasses.values().forEach(generated -> {
                    block15: {
                        boolean shouldWarningsBeSuppressed = false;
                        try {
                            String content = generated.generate();
                            if (content.length() <= 0) break block15;
                            JavaFileObject target = this.processingEnv.getFiler().createSourceFile(((GeneratedFile)generated).uri, new Element[0]);
                            try (Writer writer = target.openWriter();){
                                writer.write(content);
                            }
                            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated.get((int)0)).model.getFqn() + ": " + ((GeneratedFile)generated).uri);
                        }
                        catch (GenException e) {
                            this.reportGenException(e);
                        }
                        catch (Exception e) {
                            this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                        }
                    }
                });
            }
        } else {
            for (GeneratedFile generated2 : this.generatedResources.values()) {
                boolean shouldWarningsBeSuppressed = false;
                try {
                    boolean createSource;
                    String content = generated2.generate();
                    if (content.length() <= 0) continue;
                    try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                        w.write(content);
                    }
                    try {
                        this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri);
                        createSource = true;
                    }
                    catch (FilerException e) {
                        createSource = false;
                    }
                    if (createSource) {
                        try (Writer w = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", generated2.uri, new Element[0]).openWriter();){
                            w.write(content);
                        }
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated2.get((int)0)).model.getFqn() + ": " + generated2.uri);
                }
                catch (GenException e) {
                    this.reportGenException(e);
                }
                catch (Exception e) {
                    this.reportException(e, ((ModelProcessing)generated2.get((int)0)).model.getElement());
                }
            }
            this.generatedFiles.values().forEach(generated -> {
                Path path = new File(((GeneratedFile)generated).uri).toPath();
                if (!path.isAbsolute()) {
                    if (this.outputDirectory != null) {
                        path = this.outputDirectory.toPath().resolve(path);
                    } else {
                        return;
                    }
                }
                File file = path.toFile();
                Helper.ensureParentDir(file);
                String content = generated.generate();
                if (content.length() > 0) {
                    try (FileWriter fileWriter = new FileWriter(file);){
                        fileWriter.write(content);
                    }
                    catch (GenException e) {
                        this.reportGenException(e);
                    }
                    catch (Exception e) {
                        this.reportException(e, ((ModelProcessing)generated.get((int)0)).model.getElement());
                    }
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated model " + ((ModelProcessing)generated.get((int)0)).model.getFqn() + ": " + ((GeneratedFile)generated).uri);
                }
            });
        }
        return true;
    }

    private void reportGenException(GenException e) {
        String name = e.element.toString();
        if (e.element.getKind() == ElementKind.METHOD) {
            name = e.element.getEnclosingElement() + "#" + name;
        }
        String msg = "Could not generate model for " + name + ": " + e.msg;
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e.element);
    }

    private void reportException(Exception e, Element elt) {
        String msg = "Could not generate element for " + elt + ": " + e.getMessage();
        log.log(Level.SEVERE, msg, e);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, elt);
    }

    private static class GeneratedFile
    extends ArrayList<ModelProcessing> {
        private final String uri;
        private final Map<String, Object> session = new HashMap<String, Object>();

        public GeneratedFile(String uri) {
            this.uri = uri;
        }

        @Override
        public boolean add(ModelProcessing modelProcessing) {
            if (!modelProcessing.generator.incremental) {
                this.clear();
            }
            return super.add(modelProcessing);
        }

        String generate() {
            Collections.sort(this, (o1, o2) -> o1.model.getElement().getSimpleName().toString().compareTo(o2.model.getElement().getSimpleName().toString()));
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                ModelProcessing processing = (ModelProcessing)this.get(i);
                try {
                    String part = processing.generator.render(processing.model, i, this.size(), this.session);
                    if (part == null) continue;
                    buffer.append(part);
                    continue;
                }
                catch (GenException e) {
                    throw e;
                }
                catch (Exception e) {
                    GenException genException = new GenException(processing.model.getElement(), e.getMessage());
                    genException.initCause(e);
                    throw genException;
                }
            }
            return buffer.toString();
        }
    }

    private static class ModelProcessing {
        final Model model;
        final Generator generator;

        public ModelProcessing(Model model, Generator generator) {
            this.model = model;
            this.generator = generator;
        }
    }
}

