/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.tracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.tag.IntTag;
import io.opentracing.tag.Tags;
import io.vertx.kafka.client.consumer.KafkaConsumerRecord;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.RecordMetadata;
import java.util.Objects;
import org.eclipse.hono.client.kafka.tracing.KafkaHeadersExtractAdapter;
import org.eclipse.hono.client.kafka.tracing.KafkaHeadersInjectAdapter;
import org.eclipse.hono.client.kafka.tracing.LongTag;
import org.eclipse.hono.tracing.TracingHelper;

public final class KafkaTracingHelper {
    public static final LongTag TAG_OFFSET = new LongTag("offset");
    public static final IntTag TAG_PARTITION = new IntTag("partition");
    public static final LongTag TAG_TIMESTAMP = new LongTag("timestamp");

    private KafkaTracingHelper() {
    }

    public static Span newProducerSpan(Tracer tracer, String operationName, String topic, String referenceType, SpanContext parent) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(operationName);
        Objects.requireNonNull(topic);
        Objects.requireNonNull(referenceType);
        return TracingHelper.buildSpan(tracer, parent, operationName, referenceType).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), "hono-client-kafka").withTag(Tags.SPAN_KIND.getKey(), "producer").withTag(Tags.MESSAGE_BUS_DESTINATION.getKey(), topic).withTag(Tags.PEER_SERVICE.getKey(), "kafka").start();
    }

    public static void setRecordMetadataTags(Span span, RecordMetadata recordMetadata) {
        TAG_OFFSET.set(span, recordMetadata.getOffset());
        TAG_PARTITION.set(span, recordMetadata.getPartition());
        TAG_TIMESTAMP.set(span, recordMetadata.getTimestamp());
    }

    public static void setRecordTags(Span span, KafkaConsumerRecord<?, ?> record) {
        Tags.MESSAGE_BUS_DESTINATION.set(span, record.topic());
        TAG_OFFSET.set(span, record.offset());
        TAG_PARTITION.set(span, record.partition());
        TAG_TIMESTAMP.set(span, record.timestamp());
    }

    public static <V> void injectSpanContext(Tracer tracer, KafkaProducerRecord<String, V> record, SpanContext spanContext) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(record);
        if (spanContext != null && !(spanContext instanceof NoopSpanContext)) {
            tracer.inject(spanContext, Format.Builtin.TEXT_MAP, new KafkaHeadersInjectAdapter(record.headers()));
        }
    }

    public static <V> SpanContext extractSpanContext(Tracer tracer, KafkaConsumerRecord<String, V> record) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(record);
        return tracer.extract(Format.Builtin.TEXT_MAP, new KafkaHeadersExtractAdapter(record.headers()));
    }
}

