/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

public final class Pair<A, B> {
    private final A one;
    private final B two;
    private String stringRep;

    private Pair(A one, B two) {
        if (one == null && two == null) {
            throw new IllegalArgumentException("at least one argument must be non-null");
        }
        this.one = one;
        this.two = two;
    }

    public static <A, B> Pair<A, B> of(A one, B two) {
        return new Pair<A, B>(one, two);
    }

    public A one() {
        return this.one;
    }

    public B two() {
        return this.two;
    }

    public String toString() {
        if (this.stringRep == null) {
            this.stringRep = String.format("Pair[one: %s, two: %s]", this.one, this.two);
        }
        return this.stringRep;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.one == null ? 0 : this.one.hashCode());
        result = 31 * result + (this.two == null ? 0 : this.two.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.one == null ? other.one != null : !this.one.equals(other.one)) {
            return false;
        }
        return !(this.two == null ? other.two != null : !this.two.equals(other.two));
    }
}

