/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeferredConnectionCheckHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeferredConnectionCheckHandler.class);
    private final AtomicReference<List<ExpiringConnectionCheckPromise>> connectionCheckPromises = new AtomicReference();
    private final Vertx vertx;

    public DeferredConnectionCheckHandler(Vertx vertx) {
        this.vertx = vertx;
    }

    public boolean isConnectionAttemptInProgress() {
        return this.connectionCheckPromises.get() != null;
    }

    public void setConnectionAttemptInProgress() {
        this.connectionCheckPromises.compareAndSet(null, Collections.emptyList());
    }

    public void setConnectionAttemptFinished(AsyncResult<HonoConnection> connectionResult) {
        List promises = this.connectionCheckPromises.getAndSet(null);
        if (promises != null && !promises.isEmpty()) {
            LOG.trace("completing {} accumulated connection checks", (Object)promises.size());
            Context ctx = this.vertx.getOrCreateContext();
            promises.forEach(promise -> ctx.runOnContext(v -> promise.tryCompleteAndCancelTimer(connectionResult)));
        }
    }

    public boolean addConnectionCheck(Handler<AsyncResult<Void>> resultHandler, long waitForCurrentConnectAttemptTimeout) {
        if (waitForCurrentConnectAttemptTimeout <= 0L) {
            throw new IllegalArgumentException("timeout must be greater 0");
        }
        if (!this.isConnectionAttemptInProgress()) {
            return false;
        }
        ExpiringConnectionCheckPromise promiseToAdd = new ExpiringConnectionCheckPromise(resultHandler);
        if (!this.addToConnectionCheckPromises(promiseToAdd)) {
            return false;
        }
        promiseToAdd.startExpirationTimer(waitForCurrentConnectAttemptTimeout, v -> this.removeFromConnectionCheckPromises(promiseToAdd));
        return true;
    }

    private boolean addToConnectionCheckPromises(ExpiringConnectionCheckPromise promiseToAdd) {
        List<ExpiringConnectionCheckPromise> newPromises = this.connectionCheckPromises.accumulateAndGet(Collections.singletonList(promiseToAdd), (existing, toAdd) -> {
            if (existing == null) {
                return null;
            }
            ArrayList<ExpiringConnectionCheckPromise> promises = new ArrayList<ExpiringConnectionCheckPromise>(existing.size() + 1);
            promises.addAll((Collection<ExpiringConnectionCheckPromise>)existing);
            promises.add((ExpiringConnectionCheckPromise)toAdd.get(0));
            return promises;
        });
        return newPromises != null;
    }

    private void removeFromConnectionCheckPromises(ExpiringConnectionCheckPromise promiseToRemove) {
        this.connectionCheckPromises.accumulateAndGet(Collections.singletonList(promiseToRemove), (existing, toRemove) -> {
            if (existing == null) {
                return null;
            }
            ArrayList promises = new ArrayList(existing);
            promises.remove(toRemove.get(0));
            return promises;
        });
    }

    private class ExpiringConnectionCheckPromise {
        private final Promise<Void> promise = Promise.promise();
        private Long timerId;

        ExpiringConnectionCheckPromise(Handler<AsyncResult<Void>> connectionCheckResultHandler) {
            this.promise.future().onComplete(connectionCheckResultHandler);
        }

        public void startExpirationTimer(long timeout, Consumer<Void> postExpirationOperation) {
            this.timerId = DeferredConnectionCheckHandler.this.vertx.setTimer(timeout, id -> {
                LOG.debug("canceling connection check after {}ms", (Object)timeout);
                this.timerId = null;
                this.promise.tryFail(new ServerErrorException(503, "not connected"));
                if (postExpirationOperation != null) {
                    postExpirationOperation.accept(null);
                }
            });
        }

        public void tryCompleteAndCancelTimer(AsyncResult<HonoConnection> connectionResult) {
            if (this.timerId != null) {
                DeferredConnectionCheckHandler.this.vertx.cancelTimer(this.timerId);
            }
            if (connectionResult.succeeded()) {
                this.promise.tryComplete();
            } else {
                this.promise.tryFail(connectionResult.cause());
            }
        }
    }
}

