/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.net.SocketAddress;
import java.util.function.Consumer;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.http.HttpConnection.class)
public class HttpConnection {
    public static final TypeArg<HttpConnection> __TYPE_ARG = new TypeArg<HttpConnection>(obj -> new HttpConnection((io.vertx.core.http.HttpConnection)obj), HttpConnection::getDelegate);
    private final io.vertx.core.http.HttpConnection delegate;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
        this.delegate = delegate;
    }

    public HttpConnection(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpConnection)delegate;
    }

    HttpConnection() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpConnection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpConnection that = (HttpConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public int getWindowSize() {
        int ret = this.delegate.getWindowSize();
        return ret;
    }

    @Fluent
    public HttpConnection setWindowSize(int windowSize) {
        this.delegate.setWindowSize(windowSize);
        return this;
    }

    @Fluent
    public HttpConnection goAway(long errorCode) {
        this.delegate.goAway(errorCode);
        return this;
    }

    @Fluent
    public HttpConnection goAway(long errorCode, int lastStreamId) {
        this.delegate.goAway(errorCode, lastStreamId);
        return this;
    }

    @Fluent
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        this.delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
        return this;
    }

    @Fluent
    private HttpConnection __goAwayHandler(Handler<GoAway> handler) {
        this.delegate.goAwayHandler(handler);
        return this;
    }

    public HttpConnection goAwayHandler(Consumer<GoAway> handler) {
        return this.__goAwayHandler((Handler<GoAway>)(handler != null ? new DelegatingConsumerHandler<GoAway>(handler) : null));
    }

    @Fluent
    private HttpConnection __shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public HttpConnection shutdownHandler(Runnable handler) {
        return this.__shutdownHandler(ignored -> handler.run());
    }

    @CheckReturnValue
    public Uni<Void> shutdown() {
        return AsyncResultUni.toUni(handler -> this.delegate.shutdown((Handler<AsyncResult<Void>>)handler));
    }

    public Void shutdownAndAwait() {
        return this.shutdown().await().indefinitely();
    }

    public void shutdownAndForget() {
        this.shutdown().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> shutdown(long timeout) {
        return AsyncResultUni.toUni(handler -> this.delegate.shutdown(timeout, (Handler<AsyncResult<Void>>)handler));
    }

    public Void shutdownAndAwait(long timeout) {
        return this.shutdown(timeout).await().indefinitely();
    }

    public void shutdownAndForget(long timeout) {
        this.shutdown(timeout).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private HttpConnection __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpConnection closeHandler(Runnable handler) {
        return this.__closeHandler(ignored -> handler.run());
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public Http2Settings settings() {
        Http2Settings ret = this.delegate.settings();
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> updateSettings(Http2Settings settings) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.updateSettings(settings, (Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void updateSettingsAndAwait(Http2Settings settings) {
        return this.updateSettings(settings).await().indefinitely();
    }

    @Fluent
    public HttpConnection updateSettingsAndForget(Http2Settings settings) {
        this.updateSettings(settings).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Http2Settings remoteSettings() {
        Http2Settings ret = this.delegate.remoteSettings();
        return ret;
    }

    @Fluent
    private HttpConnection __remoteSettingsHandler(Handler<Http2Settings> handler) {
        this.delegate.remoteSettingsHandler(handler);
        return this;
    }

    public HttpConnection remoteSettingsHandler(Consumer<Http2Settings> handler) {
        return this.__remoteSettingsHandler((Handler<Http2Settings>)(handler != null ? new DelegatingConsumerHandler<Http2Settings>(handler) : null));
    }

    @CheckReturnValue
    public Uni<Buffer> ping(Buffer data) {
        return AsyncResultUni.toUni(pongHandler -> this.delegate.ping(data.getDelegate(), new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)pongHandler, ar -> ar.map(event -> Buffer.newInstance(event)))));
    }

    public Buffer pingAndAwait(Buffer data) {
        return this.ping(data).await().indefinitely();
    }

    @Fluent
    public HttpConnection pingAndForget(Buffer data) {
        this.ping(data).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private HttpConnection __pingHandler(Handler<Buffer> handler) {
        this.delegate.pingHandler(new DelegatingHandler<io.vertx.core.buffer.Buffer, Buffer>(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    public HttpConnection pingHandler(Consumer<Buffer> handler) {
        return this.__pingHandler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler<Buffer>(handler) : null));
    }

    @Fluent
    private HttpConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler<Throwable>(handler) : null));
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress remoteAddress(boolean real) {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.remoteAddress(real));
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public SocketAddress localAddress(boolean real) {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.localAddress(real));
        return ret;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
        return arg != null ? new HttpConnection(arg) : null;
    }
}

