/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.Pluralize;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.CachedSingleThreadScheduler;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String ALL_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String WINDOWS = "win";
    public static final String OS_NAME = "os.name";
    public static final String PATH_WINDOWS = "Path";
    public static final String PATH_UNIX = "PATH";
    private static final Random random = new Random();
    private static final CachedSingleThreadScheduler SHARED_SCHEDULER = new CachedSingleThreadScheduler();

    private Utils() {
    }

    public static <T> T checkNotNull(T ref, String message) {
        if (ref == null) {
            throw new NullPointerException(message);
        }
        return ref;
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String envVarName, String defaultValue) {
        String answer = System.getProperty(systemPropertyName);
        if (Utils.isNotNullOrEmpty(answer)) {
            return answer;
        }
        answer = System.getenv(envVarName);
        if (Utils.isNotNullOrEmpty(answer)) {
            return answer;
        }
        return defaultValue;
    }

    public static String convertSystemPropertyNameToEnvVar(String systemPropertyName) {
        return systemPropertyName.toUpperCase(Locale.ROOT).replaceAll("[.-]", "_");
    }

    public static String getEnvVar(String envVarName, String defaultValue) {
        String answer = System.getenv(envVarName);
        return Utils.isNotNullOrEmpty(answer) ? answer : defaultValue;
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String defaultValue) {
        return Utils.getSystemPropertyOrEnvVar(systemPropertyName, Utils.convertSystemPropertyNameToEnvVar(systemPropertyName), defaultValue);
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName) {
        return Utils.getSystemPropertyOrEnvVar(systemPropertyName, (String)null);
    }

    public static boolean getSystemPropertyOrEnvVar(String systemPropertyName, Boolean defaultValue) {
        String result = Utils.getSystemPropertyOrEnvVar(systemPropertyName, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static int getSystemPropertyOrEnvVar(String systemPropertyName, int defaultValue) {
        String result = Utils.getSystemPropertyOrEnvVar(systemPropertyName, Integer.toString(defaultValue));
        return Integer.parseInt(result);
    }

    public static String join(Object[] array) {
        return Utils.join(array, ',');
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static boolean waitUntilReady(Future<?> future, long amount, TimeUnit timeUnit) {
        try {
            if (amount < 0L) {
                future.get();
            } else {
                future.get(amount, timeUnit);
            }
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (ExecutionException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            t.addSuppressed(new Throwable("waiting here"));
            throw KubernetesClientException.launderThrowable(t);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static void waitUntilReadyOrFail(Future<?> future, long amount, TimeUnit timeUnit) {
        if (!Utils.waitUntilReady(future, amount, timeUnit)) {
            throw KubernetesClientException.launderThrowable(new TimeoutException("not ready after " + amount + " " + (Object)((Object)timeUnit)));
        }
    }

    public static void closeQuietly(Iterable<? extends Closeable> closeables) {
        for (Closeable closeable : closeables) {
            try {
                if (closeable instanceof Flushable) {
                    ((Flushable)((Object)closeable)).flush();
                }
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error closing: {}", (Object)closeable);
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        Utils.closeQuietly(Arrays.asList(closeables));
    }

    public static String coalesce(String ... items) {
        for (String str : items) {
            if (str == null) continue;
            return str;
        }
        return null;
    }

    public static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(ALL_CHARS.length());
            sb.append(ALL_CHARS.charAt(index));
        }
        return sb.toString();
    }

    public static String filePath(URL path) {
        if (path == null) {
            throw new KubernetesClientException("Path is required");
        }
        try {
            return Paths.get(path.toURI()).toString();
        }
        catch (URISyntaxException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static String replaceAllWithoutRegex(String text, String from, String to) {
        if (text == null) {
            return null;
        }
        int idx = 0;
        while ((idx = text.indexOf(from, idx)) >= 0) {
            text = text.substring(0, idx) + to + text.substring(idx + from.length());
            idx += to.length();
        }
        return text;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotNullOrEmpty(Map map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String str) {
        return !Utils.isNullOrEmpty(str);
    }

    public static boolean isNotNullOrEmpty(String[] array) {
        return array != null && array.length != 0;
    }

    public static <T> boolean isNotNull(T ... refList) {
        return Optional.ofNullable(refList).map(refs -> Stream.of(refs).allMatch(Objects::nonNull)).orElse(false);
    }

    public static <T> T getNonNullOrElse(T obj, T defaultObj) {
        return obj != null ? obj : defaultObj;
    }

    public static String getProperty(Map<String, Object> properties, String propertyName, String defaultValue) {
        String answer = (String)properties.get(propertyName);
        if (!Utils.isNullOrEmpty(answer)) {
            return answer;
        }
        return Utils.getSystemPropertyOrEnvVar(propertyName, defaultValue);
    }

    public static String getProperty(Map<String, Object> properties, String propertyName) {
        return Utils.getProperty(properties, propertyName, null);
    }

    public static String toUrlEncoded(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Deprecated
    public static String getPluralFromKind(String kind) {
        return Pluralize.toPlural(kind.toLowerCase(Locale.ROOT));
    }

    public static boolean isResourceNamespaced(Class kubernetesResourceType) {
        return Namespaced.class.isAssignableFrom(kubernetesResourceType);
    }

    public static String getAnnotationValue(Class kubernetesResourceType, Class annotationClass) {
        Object annotation = kubernetesResourceType.getAnnotation(annotationClass);
        if (annotation instanceof Group) {
            return ((Group)annotation).value();
        }
        if (annotation instanceof Version) {
            return ((Version)annotation).value();
        }
        return null;
    }

    public static String interpolateString(String templateInput, Map<String, String> valuesMap) {
        return (String)Optional.ofNullable(valuesMap).orElse(Collections.emptyMap()).entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> entry.getValue() != null).flatMap(entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            return Stream.of(new AbstractMap.SimpleEntry<String, String>("${" + key + "}", value), new AbstractMap.SimpleEntry<String, String>("\"${{" + key + "}}\"", value), new AbstractMap.SimpleEntry<String, String>("${{" + key + "}}", value));
        }).map(explodedParam -> s -> s.replace((CharSequence)explodedParam.getKey(), (CharSequence)explodedParam.getValue())).reduce(Function.identity(), Function::andThen).apply(Objects.requireNonNull(templateInput, "templateInput is required"));
    }

    public static boolean isWindowsOperatingSystem() {
        return Utils.getOperatingSystemFromSystemProperty().toLowerCase().contains(WINDOWS);
    }

    public static String getSystemPathVariable() {
        return System.getenv(Utils.isWindowsOperatingSystem() ? PATH_WINDOWS : PATH_UNIX);
    }

    public static List<String> getCommandPlatformPrefix() {
        ArrayList<String> platformPrefixParts = new ArrayList<String>();
        if (Utils.isWindowsOperatingSystem()) {
            platformPrefixParts.add("cmd.exe");
            platformPrefixParts.add("/c");
        } else {
            platformPrefixParts.add("sh");
            platformPrefixParts.add("-c");
        }
        return platformPrefixParts;
    }

    private static String getOperatingSystemFromSystemProperty() {
        return System.getProperty(OS_NAME);
    }

    public static ThreadFactory daemonThreadFactory(Object forObject) {
        String name = forObject.getClass().getSimpleName() + "-" + System.identityHashCode(forObject);
        return Utils.daemonThreadFactory(name);
    }

    static ThreadFactory daemonThreadFactory(final String name) {
        return new ThreadFactory(){
            ThreadFactory threadFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread ret = this.threadFactory.newThread(r);
                ret.setName(name + "-" + ret.getName());
                ret.setDaemon(true);
                return ret;
            }
        };
    }

    public static CompletableFuture<Void> schedule(Executor executor, Runnable command, long delay, TimeUnit unit) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ScheduledFuture<?> scheduledFuture = SHARED_SCHEDULER.schedule(() -> {
            try {
                executor.execute(command);
                result.complete(null);
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        }, delay, unit);
        result.whenComplete((v, t) -> scheduledFuture.cancel(true));
        return result;
    }

    public static CompletableFuture<?> scheduleAtFixedRate(Executor executor, Runnable command, long initialDelay, long delay, TimeUnit unit) {
        CompletableFuture completion = new CompletableFuture();
        Utils.scheduleWithVariableRate(completion, executor, command, initialDelay, () -> delay, unit);
        return completion;
    }

    public static void scheduleWithVariableRate(CompletableFuture<?> completion, Executor executor, Runnable command, long initialDelay, LongSupplier nextDelay, TimeUnit unit) {
        AtomicReference currentScheduledFuture = new AtomicReference();
        AtomicLong next = new AtomicLong(unit.convert(System.nanoTime(), TimeUnit.NANOSECONDS) + Math.max(0L, initialDelay));
        Utils.schedule(() -> CompletableFuture.runAsync(command, executor), initialDelay, unit, completion, nextDelay, next, currentScheduledFuture);
        completion.whenComplete((v, t) -> Optional.ofNullable(currentScheduledFuture.get()).ifPresent(s -> s.cancel(true)));
    }

    private static void schedule(Supplier<CompletableFuture<?>> runner, long delay, TimeUnit unit, CompletableFuture<?> completion, LongSupplier nextDelay, AtomicLong next, AtomicReference<ScheduledFuture<?>> currentScheduledFuture) {
        currentScheduledFuture.set(SHARED_SCHEDULER.schedule(() -> {
            if (completion.isDone()) {
                return;
            }
            CompletableFuture runAsync = (CompletableFuture)runner.get();
            runAsync.whenComplete((arg_0, arg_1) -> Utils.lambda$null$12(completion, (Supplier)runner, next, nextDelay, unit, currentScheduledFuture, arg_0, arg_1));
        }, delay, unit));
    }

    private static /* synthetic */ void lambda$null$12(CompletableFuture completion, Supplier runner, AtomicLong next, LongSupplier nextDelay, TimeUnit unit, AtomicReference currentScheduledFuture, Object v, Throwable t) {
        if (t != null) {
            completion.completeExceptionally(t);
        } else if (!completion.isDone()) {
            Utils.schedule(runner, next.addAndGet(nextDelay.getAsLong()) - unit.convert(System.nanoTime(), TimeUnit.NANOSECONDS), unit, completion, nextDelay, next, currentScheduledFuture);
        }
    }
}

