/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.uni.UniOnSubscribeCall;
import io.smallrye.mutiny.operators.uni.UniOnSubscribeInvoke;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class UniOnSubscribe<T> {
    private final Uni<T> upstream;

    public UniOnSubscribe(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Uni<T> invoke(Consumer<? super UniSubscription> callback) {
        Consumer<? super UniSubscription> actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return Infrastructure.onUniCreation(new UniOnSubscribeInvoke<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super UniSubscription ignored) -> actual.run());
    }

    @CheckReturnValue
    public Uni<T> call(Function<? super UniSubscription, Uni<?>> action) {
        Function<? super UniSubscription, Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return Infrastructure.onUniCreation(new UniOnSubscribeCall<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Uni<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.call((? super UniSubscription ignored) -> (Uni)actual.get());
    }
}

