/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen;

import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.codegen.lang.BufferRelatedMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ClassDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ClassJavadocCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.CodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstantCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstructorWithDelegateParameterCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstructorWithGenericTypesCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConstructorWithObjectDelegateCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ConsumerMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.DelegateFieldCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.DelegateMethodDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.FunctionApplyMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.GetDelegateMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.HashCodeAndEqualsMethodsCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ImplClassCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ImportDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.IterableMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.IteratorMethodsCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.MutinyGenAnnotationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.NewInstanceMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.NewInstanceWithGenericsMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.NoArgConstructorCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.PackageDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ReadStreamMethodDeclarationCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ToMultiMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ToStringMethodCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.ToSubscriberCodeWriter;
import io.smallrye.mutiny.vertx.codegen.lang.TypeArgsConstantCodeWriter;
import io.smallrye.mutiny.vertx.codegen.methods.AwaitMethodGenerator;
import io.smallrye.mutiny.vertx.codegen.methods.ConsumerMethodGenerator;
import io.smallrye.mutiny.vertx.codegen.methods.ForgetMethodGenerator;
import io.smallrye.mutiny.vertx.codegen.methods.SimpleMethodGenerator;
import io.smallrye.mutiny.vertx.codegen.methods.UniMethodGenerator;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Generator;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.annotations.ModuleGen;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeReflectionFactory;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;

public class MutinyGenerator
extends Generator<ClassModel> {
    public static final String ID = "mutiny";
    private List<MethodInfo> methods = new ArrayList<MethodInfo>();
    private final Map<MethodInfo, Map<TypeInfo, String>> methodTypeArgMap = new HashMap<MethodInfo, Map<TypeInfo, String>>();
    public static List<String> IGNORED_TYPES = Arrays.asList(Future.class.getName(), CompositeFuture.class.getName());
    private final List<CodeWriter> generators = Arrays.asList(new PackageDeclarationCodeWriter(), new ImportDeclarationCodeWriter(), new ClassJavadocCodeWriter(), new MutinyGenAnnotationCodeWriter(), new ClassDeclarationCodeWriter(), new TypeArgsConstantCodeWriter(), new DelegateFieldCodeWriter(), new ConstructorWithDelegateParameterCodeWriter(), new ConstructorWithObjectDelegateCodeWriter(), new ConstructorWithGenericTypesCodeWriter(), new NoArgConstructorCodeWriter(), new GetDelegateMethodCodeWriter(), (mode, writer) -> this.methodTypeArgMap.forEach((method, map) -> map.forEach((typeArg, identifier) -> this.genTypeArgDecl((TypeInfo)typeArg, (MethodInfo)method, (String)identifier, writer))), new DelegateMethodDeclarationCodeWriter(), new BufferRelatedMethodCodeWriter(), new ToStringMethodCodeWriter(), new HashCodeAndEqualsMethodsCodeWriter(), new IterableMethodCodeWriter(), new IteratorMethodsCodeWriter(), new FunctionApplyMethodCodeWriter(), new ToSubscriberCodeWriter(), new ReadStreamMethodDeclarationCodeWriter(), (model, writer) -> {
        if (model.isConcrete()) {
            this.generateClassBody(model, writer);
        } else {
            this.methods.forEach(method -> this.generateMethodDeclaration(model, (MethodInfo)method, Collections.emptyList(), writer));
        }
    }, new ToMultiMethodCodeWriter(), new ConsumerMethodCodeWriter(), new NewInstanceMethodCodeWriter(), new NewInstanceWithGenericsMethodCodeWriter(), (model, writer) -> writer.println("}"), new ImplClassCodeWriter(this));

    MutinyGenerator() {
        this.kinds = Collections.singleton("class");
        this.name = ID;
    }

    protected void genMethods(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        this.generateMethod(model, method, cacheDecls, writer);
        MethodInfo publisherOverload = this.genOverloadedMethod(method);
        if (publisherOverload != null) {
            this.generateMethod(model, publisherOverload, cacheDecls, writer);
        }
    }

    private MethodInfo genOverloadedMethod(MethodInfo method) {
        ArrayList<ParamInfo> params = null;
        int count = 0;
        for (ParamInfo param : method.getParams()) {
            if (param.getType().isParameterized() && param.getType().getRaw().getName().equals("io.vertx.core.streams.ReadStream")) {
                if (params == null) {
                    params = new ArrayList<ParamInfo>(method.getParams());
                }
                ParameterizedTypeInfo paramType = new ParameterizedTypeInfo(TypeReflectionFactory.create(Flow.Publisher.class).getRaw(), false, Collections.singletonList(((ParameterizedTypeInfo)param.getType()).getArg(0)));
                params.set(count, new ParamInfo(param.getIndex(), param.getName(), param.getDescription(), paramType));
            }
            ++count;
        }
        if (params != null) {
            return method.copy().setParams(params);
        }
        return null;
    }

    @Override
    public Collection<Class<? extends Annotation>> annotations() {
        return Arrays.asList(VertxGen.class, ModuleGen.class);
    }

    @Override
    public String filename(ClassModel model) {
        ModuleInfo module = model.getModule();
        return module.translateQualifiedName(model.getFqn(), ID) + ".java";
    }

    @Override
    public String render(ClassModel model, int index, int size, Map<String, Object> session) {
        if (IGNORED_TYPES.contains(model.getFqn())) {
            return null;
        }
        this.initState(model);
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.generateClass(model, writer);
        return sw.toString();
    }

    private void initState(ClassModel model) {
        this.initGenMethods(model);
        this.initCachedTypeArgs();
    }

    private void generateClass(ClassModel model, PrintWriter writer) {
        this.generators.forEach(cw -> cw.apply(model, writer));
    }

    public void generateClassBody(ClassModel model, PrintWriter writer) {
        ArrayList cacheDecls = new ArrayList();
        this.methods.forEach(method -> this.genMethods(model, (MethodInfo)method, cacheDecls, writer));
        new ConstantCodeWriter(this.methodTypeArgMap).apply(model, writer);
        for (String cacheDecl : cacheDecls) {
            writer.print("  ");
            writer.print(cacheDecl);
            writer.println(";");
        }
    }

    private void initGenMethods(ClassModel model) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        List infos = model.getMethods().stream().filter(mi -> !mi.getReturnType().getName().equals(Future.class.getName())).filter(mi -> {
            for (ClassTypeInfo ownerType : mi.getOwnerTypes()) {
                if (!IGNORED_TYPES.contains(ownerType.getName())) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        list.add(infos);
        list.add(model.getAnyJavaTypeMethods());
        list.forEach(methods -> {
            ListIterator it = methods.listIterator();
            while (it.hasNext()) {
                MethodInfo method = (MethodInfo)it.next();
                if (CodeGenHelper.methodKind(method) == MethodKind.CALLBACK) continue;
                Predicate<MethodInfo> pred = method.isOwnedBy(model.getType()) ? other -> this.isOverride(method, (MethodInfo)other) : other -> this.isOverride(method, (MethodInfo)other);
                if (!methods.stream().filter(m -> CodeGenHelper.methodKind(m) == MethodKind.CALLBACK).anyMatch(pred)) continue;
                it.remove();
            }
            it = methods.listIterator();
            while (it.hasNext()) {
                MethodInfo meth = (MethodInfo)it.next();
                if (CodeGenHelper.methodKind(meth) != MethodKind.CALLBACK) continue;
                List abc = model.getMethodMap().getOrDefault(meth.getName(), Collections.emptyList());
                boolean remove = meth.isOwnedBy(model.getType()) ? abc.stream().filter(m -> CodeGenHelper.methodKind(m) != MethodKind.CALLBACK && this.isOverride((MethodInfo)m, meth)).anyMatch(m -> !m.isOwnedBy(model.getType()) || methods.contains(m)) : abc.stream().filter(other -> CodeGenHelper.methodKind(other) != MethodKind.CALLBACK).anyMatch(other -> {
                    if (CodeGenHelper.methodKind(other) != MethodKind.CALLBACK) {
                        HashSet<ClassTypeInfo> tmp = new HashSet<ClassTypeInfo>(other.getOwnerTypes());
                        tmp.retainAll(meth.getOwnerTypes());
                        return this.isOverride(meth, (MethodInfo)other) & !tmp.isEmpty();
                    }
                    return false;
                });
                if (!remove) continue;
                it.remove();
            }
        });
        this.methods = list.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void initCachedTypeArgs() {
        this.methodTypeArgMap.clear();
        int count = 0;
        for (MethodInfo method : this.methods) {
            TypeInfo returnType = method.getReturnType();
            if (!(returnType instanceof ParameterizedTypeInfo)) continue;
            ParameterizedTypeInfo parameterizedType = (ParameterizedTypeInfo)returnType;
            List<TypeInfo> typeArgs = parameterizedType.getArgs();
            HashMap<TypeInfo, CallSite> typeArgMap = new HashMap<TypeInfo, CallSite>();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.getKind() != ClassKind.API || this.containsTypeVariableArgument(typeArg)) continue;
                String typeArgRef = "TYPE_ARG_" + count++;
                typeArgMap.put(typeArg, (CallSite)((Object)typeArgRef));
            }
            this.methodTypeArgMap.put(method, typeArgMap);
        }
    }

    private boolean containsTypeVariableArgument(TypeInfo type) {
        if (type.isVariable()) {
            return true;
        }
        if (type.isParameterized()) {
            List<TypeInfo> typeArgs = ((ParameterizedTypeInfo)type).getArgs();
            for (TypeInfo typeArg : typeArgs) {
                if (typeArg.isVariable()) {
                    return true;
                }
                if (!typeArg.isParameterized() || !this.containsTypeVariableArgument(typeArg)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOverride(MethodInfo s1, MethodInfo s2) {
        if (s1.getName().equals(s2.getName()) && s1.getParams().size() == s2.getParams().size() - 1) {
            for (int i = 0; i < s1.getParams().size(); ++i) {
                if (s1.getParams().get(i).getType().equals(s2.getParams().get(i).getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    final void generateMethod(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        UniMethodGenerator uni = new UniMethodGenerator(writer, this.methodTypeArgMap);
        ForgetMethodGenerator forget = new ForgetMethodGenerator(writer);
        AwaitMethodGenerator await = new AwaitMethodGenerator(writer);
        ConsumerMethodGenerator consumer = new ConsumerMethodGenerator(writer);
        SimpleMethodGenerator simple = new SimpleMethodGenerator(writer, cacheDecls, this.methodTypeArgMap);
        if (CodeGenHelper.methodKind(method) == MethodKind.CALLBACK) {
            uni.generate(model, method);
            await.generate(method);
            forget.generate(model, method);
        } else if (CodeGenHelper.methodKind(method) == MethodKind.HANDLER) {
            simple.generate(model, method);
            consumer.generate(method);
        } else if (CodeGenHelper.methodKind(method) == MethodKind.OTHER) {
            if (this.isMethodReturningAFuture(method)) {
                this.env.getMessager().printMessage(Diagnostic.Kind.WARNING, "A method returning a 'Future' has been found - missing handler method for '" + method.getName() + "' declared in " + method.getOwnerTypes().stream().map(TypeInfo::getName).collect(Collectors.joining()));
                uni.generateOther(method);
                await.generateOther(method);
                forget.generateOther(model, method);
            } else {
                simple.generateOther(model, method);
            }
        }
    }

    private boolean isMethodReturningAFuture(MethodInfo method) {
        return method.getReturnType() != null && method.getReturnType().getRaw() != null && method.getReturnType().getRaw().getName().equals(Future.class.getName());
    }

    private void generateMethodDeclaration(ClassModel model, MethodInfo method, List<String> cacheDecls, PrintWriter writer) {
        if (CodeGenHelper.methodKind(method) == MethodKind.CALLBACK) {
            new UniMethodGenerator(writer, this.methodTypeArgMap).generateDeclaration(method);
            if (model.getMethods().stream().noneMatch(mi -> mi.getName().equals(method.getName() + "AndAwait"))) {
                new AwaitMethodGenerator(writer).generateDeclaration(method);
            }
            if (model.getMethods().stream().noneMatch(mi -> mi.getName().equals(method.getName() + "AndForget"))) {
                new ForgetMethodGenerator(writer).generateDeclaration(model, method);
            }
        } else if (CodeGenHelper.methodKind(method) == MethodKind.HANDLER) {
            ConsumerMethodGenerator consumer = new ConsumerMethodGenerator(writer);
            consumer.generateDeclaration(method);
        } else {
            SimpleMethodGenerator simple = new SimpleMethodGenerator(writer, cacheDecls, this.methodTypeArgMap);
            simple.generateDeclaration(method);
        }
    }

    private void genTypeArgDecl(TypeInfo typeArg, MethodInfo method, String typeArgRef, PrintWriter writer) {
        StringBuilder sb = new StringBuilder();
        CodeGenHelper.genTypeArg(typeArg, method, 1, sb);
        writer.print("  static final ");
        writer.print(TypeArg.class.getName());
        writer.print("<");
        writer.print(typeArg.translateName(ID));
        writer.print("> ");
        writer.print(typeArgRef);
        writer.print(" = ");
        writer.print(sb);
        writer.println(";");
    }
}

