/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.ClusterDescriptionConverter;
import io.vertx.kafka.client.common.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.acl.AclOperation;

@DataObject
@JsonGen(publicConverter=false)
public class ClusterDescription {
    private String clusterId;
    private Node controller;
    private List<Node> nodes;
    private Set<AclOperation> authorizedOperations;

    public ClusterDescription() {
    }

    public ClusterDescription(String clusterId, Node controller, List<Node> nodes, Set<AclOperation> authorizedOperations) {
        this.clusterId = clusterId;
        this.controller = controller;
        this.nodes = nodes;
        this.authorizedOperations = authorizedOperations;
    }

    public ClusterDescription(JsonObject json) {
        ClusterDescriptionConverter.fromJson(json, this);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public ClusterDescription setNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public ClusterDescription addNode(Node node) {
        Objects.requireNonNull(node, "Cannot accept null node");
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        this.nodes.add(node);
        return this;
    }

    public Node getController() {
        return this.controller;
    }

    public ClusterDescription setController(Node controller) {
        this.controller = controller;
        return this;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public ClusterDescription setClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public Set<AclOperation> getAuthorizedOperations() {
        return this.authorizedOperations;
    }

    public ClusterDescription setAuthorizedOperations(Set<AclOperation> authorizedOperations) {
        this.authorizedOperations = authorizedOperations;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ClusterDescriptionConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return "ClusterDescription{clusterId=" + this.clusterId + ",controller=" + this.controller + ",nodes=" + this.nodes + ",authorizedOperatioins=" + this.authorizedOperations + "}";
    }
}

