/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.core.query;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentStructuredElementGetter {
    private IntentStructuredElementGetter() {
    }

    public static EList<IntentStructuredElement> getAllStructuredElement(EObject element) {
        BasicEList containedStructuredElements = new BasicEList();
        if (element instanceof IntentDocument) {
            containedStructuredElements.add((Object)((IntentDocument)element));
            containedStructuredElements.addAll(IntentStructuredElementGetter.getAllStructuredElementContainedInIntentDocument((IntentDocument)element));
        }
        if (element instanceof IntentChapter) {
            containedStructuredElements.addAll(IntentStructuredElementGetter.getAllStructuredElementContainedInChapter((IntentChapter)element));
        }
        if (element instanceof IntentSection) {
            containedStructuredElements.addAll(IntentStructuredElementGetter.getAllStructuredElementContainedInSection((IntentSection)element));
        }
        return containedStructuredElements;
    }

    private static EList<IntentStructuredElement> getAllStructuredElementContainedInIntentDocument(IntentDocument document) {
        BasicEList containedIntentStructuredElements = new BasicEList();
        for (IntentChapter chapter : document.getChapters()) {
            containedIntentStructuredElements.addAll(IntentStructuredElementGetter.getAllStructuredElementContainedInChapter(chapter));
        }
        return containedIntentStructuredElements;
    }

    private static EList<IntentStructuredElement> getAllStructuredElementContainedInChapter(IntentChapter chapter) {
        BasicEList containedIntentStructuredElements = new BasicEList();
        containedIntentStructuredElements.add((Object)chapter);
        for (IntentSection section : chapter.getSubSections()) {
            containedIntentStructuredElements.addAll(IntentStructuredElementGetter.getAllStructuredElementContainedInSection(section));
        }
        return containedIntentStructuredElements;
    }

    private static Collection<? extends IntentStructuredElement> getAllStructuredElementContainedInSection(IntentSection section) {
        BasicEList containedIntentStructuredElements = new BasicEList();
        containedIntentStructuredElements.add((Object)section);
        for (IntentSection subSection : section.getSubSections()) {
            containedIntentStructuredElements.addAll(IntentStructuredElementGetter.getAllStructuredElementContainedInSection(subSection));
        }
        return containedIntentStructuredElements;
    }
}

