/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.repository;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceConfig {
    private static final String REPOSITORY_STANDARD_NAME = ".repository";
    private static final String REPOSITORY_RELATIVE_PATH_FROM_PROJECT_ROOT = "/" + WorkspaceConfig.getRepositoryStandardName();
    private IProject project;
    private List<String> indexPathList;

    public WorkspaceConfig(IProject project, String[] indexesPath) {
        this.project = project;
        this.indexPathList = new ArrayList<String>();
        int i = 0;
        while (i < indexesPath.length) {
            this.indexPathList.add(indexesPath[i]);
            ++i;
        }
    }

    public List<String> getIndexesPathList() {
        return this.indexPathList;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getRepositoryAbsolutePath() {
        return this.project.getFolder(WorkspaceConfig.getRepositoryStandardName()).getFullPath().toString();
    }

    public String getRepositoryRelativePath() {
        return REPOSITORY_RELATIVE_PATH_FROM_PROJECT_ROOT;
    }

    public static String getRepositoryStandardName() {
        return REPOSITORY_STANDARD_NAME;
    }
}

