/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.factory;

import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchonizerEObjectNameGetter;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

public final class SynchronizerMessageProvider {
    private static final String SYNC_MESSAGES_SEPARATOR = " : ";
    private static final String SYNC_MESSAGES_BEGINNING = "The ";
    private static final String SYNC_MESSAGES_WHITESPACE = " ";
    private static final String SYNC_MESSAGES_INTERNAL_MODEL = "<b>Current Document</b>";
    private static final String SYNC_MESSAGES_EXTERNAL_MODEL = "<b>Working Copy</b>";

    private SynchronizerMessageProvider() {
    }

    public static String createMessageFromDiff(Diff diff) {
        String returnedMessage = null;
        if (diff instanceof ReferenceChange) {
            ReferenceChange referenceChange = (ReferenceChange)diff;
            returnedMessage = referenceChange.getReference().isContainment() ? SynchronizerMessageProvider.createMessageFromContainmentChange(referenceChange) : SynchronizerMessageProvider.createMessageFromReferenceChange(referenceChange);
        } else if (diff instanceof AttributeChange) {
            returnedMessage = SynchronizerMessageProvider.createMessageFromAttributeChange((AttributeChange)diff);
        }
        if (returnedMessage == null) {
            returnedMessage = diff.toString();
        }
        return returnedMessage;
    }

    private static String createMessageFromContainmentChange(ReferenceChange diff) {
        String returnedMessage = SYNC_MESSAGES_BEGINNING + diff.getValue().eClass().getName() + SYNC_MESSAGES_WHITESPACE + SynchonizerEObjectNameGetter.computeObjectName(diff.getValue());
        switch (diff.getKind().getValue()) {
            case 0: {
                returnedMessage = String.valueOf(returnedMessage) + " is defined in the <b>Current Document</b> model<br/>but not in the <b>Working Copy</b> model.";
                break;
            }
            case 1: {
                returnedMessage = String.valueOf(returnedMessage) + " is defined in the <b>Working Copy</b> model<br/>but not in the <b>Current Document</b> model.";
                break;
            }
            default: {
                returnedMessage = SynchronizerMessageProvider.createMessageFromReferenceChange(diff);
            }
        }
        return returnedMessage;
    }

    private static String createMessageFromReferenceChange(ReferenceChange diff) {
        String valueSignature = String.valueOf(diff.getValue().eClass().getName()) + SYNC_MESSAGES_WHITESPACE + SynchonizerEObjectNameGetter.computeObjectName(diff.getValue());
        String returnedMessage = null;
        String signature = "reference '" + diff.getReference().getName() + "'";
        switch (diff.getKind().getValue()) {
            case 0: {
                returnedMessage = SYNC_MESSAGES_BEGINNING + valueSignature + " has been added to the " + signature;
                break;
            }
            case 1: {
                returnedMessage = SYNC_MESSAGES_BEGINNING + valueSignature + " has been removed from the " + signature;
                break;
            }
            case 3: {
                returnedMessage = "The order of the values of the " + signature + " has changed";
                break;
            }
            case 2: {
                returnedMessage = SYNC_MESSAGES_BEGINNING + signature;
                EObject element = diff.getMatch().getRight();
                if (element == null) break;
                String elementLabel = SynchonizerEObjectNameGetter.computeObjectName(element);
                if (elementLabel != null) {
                    returnedMessage = String.valueOf(returnedMessage) + " in " + elementLabel;
                }
                returnedMessage = String.valueOf(returnedMessage) + " has changed.<br/>";
                returnedMessage = String.valueOf(returnedMessage) + "<b>Current Document</b> : " + SynchonizerEObjectNameGetter.computeObjectName(diff.getValue()) + "<br/>" + SYNC_MESSAGES_EXTERNAL_MODEL + SYNC_MESSAGES_SEPARATOR + SynchonizerEObjectNameGetter.computeObjectName((EObject)element.eGet((EStructuralFeature)diff.getReference()));
                break;
            }
        }
        return returnedMessage;
    }

    private static String createMessageFromAttributeChange(AttributeChange diff) {
        String returnedMessage = null;
        String signature = "attribute '" + diff.getAttribute().getName() + "'";
        switch (diff.getKind().getValue()) {
            case 0: {
                returnedMessage = SYNC_MESSAGES_BEGINNING + diff.getValue() + " has been added to " + signature;
                break;
            }
            case 1: {
                returnedMessage = SYNC_MESSAGES_BEGINNING + diff.getValue() + " has been removed from " + signature;
                break;
            }
            case 3: {
                returnedMessage = "The order of the values of " + signature + " has changed";
                break;
            }
            case 2: {
                returnedMessage = SYNC_MESSAGES_BEGINNING + signature;
                EObject element = diff.getMatch().getRight();
                String elementLabel = SynchonizerEObjectNameGetter.computeObjectName(element);
                if (elementLabel != null) {
                    returnedMessage = String.valueOf(returnedMessage) + " in " + elementLabel;
                }
                returnedMessage = String.valueOf(returnedMessage) + " has changed.<br/>";
                returnedMessage = String.valueOf(returnedMessage) + "<b>Current Document</b> : " + diff.getValue() + "<br/>" + SYNC_MESSAGES_EXTERNAL_MODEL + SYNC_MESSAGES_SEPARATOR + element.eGet((EStructuralFeature)diff.getAttribute());
                break;
            }
        }
        return returnedMessage;
    }

    public static String createMessageForNullExternalResource(ResourceDeclaration resourceDeclaration) {
        String returnedMessage = "";
        if (resourceDeclaration.getUri() != null) {
            returnedMessage = String.valueOf(returnedMessage) + "Cannot locate Resource at URI : " + resourceDeclaration.getUri().toString();
        }
        returnedMessage = String.valueOf(returnedMessage) + '.';
        return returnedMessage;
    }

    public static String createMessageForEmptyExternalResource(ResourceDeclaration resourceDeclaration) {
        String returnedMessage = "";
        if (resourceDeclaration.getUri() != null) {
            returnedMessage = String.valueOf(returnedMessage) + "The Resource at URI : " + resourceDeclaration.getUri().toString() + " is empty";
        }
        returnedMessage = String.valueOf(returnedMessage) + '.';
        return returnedMessage;
    }

    public static String createMessageForEmptyInternalResource(ResourceDeclaration resourceDeclaration) {
        String returnedMessage = "";
        if (resourceDeclaration.getUri() != null) {
            returnedMessage = String.valueOf(returnedMessage) + "The Resource " + resourceDeclaration.getName() + " is empty";
        }
        returnedMessage = String.valueOf(returnedMessage) + '.';
        return returnedMessage;
    }
}

