/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.synchronizer.strategy;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.synchronizer.factory.SynchronizerMessageProvider;
import org.eclipse.mylyn.docs.intent.client.synchronizer.strategy.SynchronizerStrategy;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.compiler.ResourceChangeStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerResourceState;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.ResourceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyInternalResourceStrategy
implements SynchronizerStrategy {
    @Override
    public Resource handleNullExternalResource(ResourceDeclaration resourceDeclaration, Resource internalResource, URI externalResourceURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource externalResource = resourceSet.createResource(externalResourceURI);
        for (EObject root : internalResource.getContents()) {
            externalResource.getContents().add((Object)EcoreUtil.copy((EObject)root));
        }
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            options.put("USE_XMI_TYPE", Boolean.TRUE);
            externalResource.save(options);
        }
        catch (IOException iOException) {
            return null;
        }
        return externalResource;
    }

    @Override
    public Resource handleNullInternalResource(String internalResourcePath, Resource externalResource) {
        return null;
    }

    @Override
    public Resource getLeftResource(Resource internalResource, Resource externalResource) {
        return internalResource;
    }

    @Override
    public Resource getRightResource(Resource internalResource, Resource externalResource) {
        return externalResource;
    }

    @Override
    public Collection<? extends CompilationStatus> getStatusForNullExternalResource(ResourceDeclaration resourceDeclaration, String resourcePath) {
        ResourceChangeStatus status = CompilerFactory.eINSTANCE.createResourceChangeStatus();
        status.setSeverity(CompilationStatusSeverity.WARNING);
        status.setTarget((IntentGenericElement)resourceDeclaration);
        status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
        status.setMessage(SynchronizerMessageProvider.createMessageForNullExternalResource(resourceDeclaration));
        status.setWorkingCopyResourceState(SynchronizerResourceState.NULL);
        return Lists.newArrayList((Object[])new ResourceChangeStatus[]{status});
    }

    @Override
    public Resource handleEmptyExternalResource(ResourceDeclaration resourceDeclaration, Resource internalResource, URI externalResourceURI) {
        return this.handleNullExternalResource(resourceDeclaration, internalResource, externalResourceURI);
    }

    @Override
    public Collection<? extends CompilationStatus> getStatusForEmptyExternalResource(ResourceDeclaration resourceDeclaration, String resourcePath) {
        ResourceChangeStatus status = CompilerFactory.eINSTANCE.createResourceChangeStatus();
        status.setCompiledResourceURI(resourcePath);
        status.setWorkingCopyResourceURI(resourceDeclaration.getUri().toString());
        status.setSeverity(CompilationStatusSeverity.WARNING);
        status.setTarget((IntentGenericElement)resourceDeclaration);
        status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
        status.setMessage(SynchronizerMessageProvider.createMessageForEmptyExternalResource(resourceDeclaration));
        status.setWorkingCopyResourceState(SynchronizerResourceState.EMPTY);
        return Lists.newArrayList((Object[])new ResourceChangeStatus[]{status});
    }

    @Override
    public Collection<? extends CompilationStatus> getStatusForEmptyInternalResource(ResourceDeclaration resourceDeclaration, String resourcePath) {
        ResourceChangeStatus status = CompilerFactory.eINSTANCE.createResourceChangeStatus();
        status.setCompiledResourceURI(resourcePath);
        status.setWorkingCopyResourceURI(resourceDeclaration.getUri().toString());
        status.setSeverity(CompilationStatusSeverity.WARNING);
        status.setTarget((IntentGenericElement)resourceDeclaration);
        status.setType(CompilationMessageType.SYNCHRONIZER_WARNING);
        status.setMessage(SynchronizerMessageProvider.createMessageForEmptyInternalResource(resourceDeclaration));
        status.setCompiledResourceState(SynchronizerResourceState.EMPTY);
        return Lists.newArrayList((Object[])new ResourceChangeStatus[]{status});
    }
}

