/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.markup.builder.state.utils;

public final class CharacterEscapedAnalyser {
    private CharacterEscapedAnalyser() {
    }

    public static boolean isLinkDeclaration(String unescaped) {
        return unescaped.contains("<a") && unescaped.contains("href=");
    }

    public static String getLinkName(String unescaped) {
        return unescaped.replaceAll("<a[ ]*href=[\"[a-z]*[.-_]]*>", "").replace("</a>", "").trim();
    }

    public static String getLinkHref(String unescaped) {
        try {
            String href = unescaped.replaceAll(">.*</a>", "");
            href = href.substring(href.indexOf(34) + 1, href.length() - 1);
            href = href.substring(0, href.indexOf(34));
            return href;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static String getLinkTitle(String unescaped) {
        String title = "";
        if (unescaped.contains("title=\"")) {
            try {
                title = unescaped.replaceAll(">.*</a>", "");
                title = title.substring(0, title.lastIndexOf("\""));
                title = title.substring(title.lastIndexOf("\"") + 1, title.length());
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }
        return title;
    }

    public static boolean isLineBreak(String unescaped) {
        return "<br/>".equals(unescaped.trim()) || "<br />".equals(unescaped.trim());
    }

    public static boolean isTabulation(String unescaped) {
        return "<dd/>".equals(unescaped.trim()) || "<dd />".equals(unescaped.trim());
    }
}

