/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.repository;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.ide.adapters.WorkspaceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceSessionDeltaVisitor
implements IResourceDeltaVisitor {
    protected WorkspaceAdapter repositoryAdapter;
    protected Collection<Resource> changedResources;
    protected Collection<Resource> removedResources;
    private String repositoryPath;

    public WorkspaceSessionDeltaVisitor(WorkspaceAdapter repositoryAdapter, Path repositoryPath) {
        Assert.isNotNull((Object)repositoryAdapter);
        this.repositoryAdapter = repositoryAdapter;
        this.changedResources = new ArrayList<Resource>();
        this.removedResources = new ArrayList<Resource>();
        this.repositoryPath = repositoryPath.toString();
    }

    public boolean visit(IResourceDelta delta) {
        URI platformResourceURI;
        String repositoryRelativePath;
        Resource resource;
        if (delta.getResource().getType() != 1) {
            return true;
        }
        if (this.isRelevantModification(delta) && delta.getResource().isAccessible() && (resource = this.repositoryAdapter.getResource(repositoryRelativePath = this.repositoryAdapter.getResourcePath(platformResourceURI = URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true)), true)) != null) {
            switch (delta.getKind()) {
                case 2: {
                    this.removedResources.add(resource);
                    break;
                }
                case 1: 
                case 4: {
                    this.changedResources.add(resource);
                    break;
                }
            }
        }
        return true;
    }

    private boolean isRelevantModification(IResourceDelta delta) {
        boolean isRelevantModification = delta.getKind() == 2 || delta.getKind() == 4 || delta.getKind() == 1;
        isRelevantModification = isRelevantModification && (delta.getFlags() & 0x20000) == 0;
        return isRelevantModification;
    }

    public Collection<Resource> getChangedResources() {
        return this.changedResources;
    }

    public Collection<Resource> getRemovedResources() {
        return this.removedResources;
    }
}

