/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import java.io.IOException;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ClientCallbackSupport {
    private static TSLogger logger = null;
    private static CallbackHandler callbackHandler = null;
    private static String profile = null;
    private static final String runtimeType = "ClientRuntime";

    public ClientCallbackSupport(TSLogger tsLogger, CallbackHandler cbkHandler, String profile) {
        logger = tsLogger;
        callbackHandler = cbkHandler;
        ClientCallbackSupport.profile = profile;
    }

    public boolean verify() {
        try {
            this.NameCallbackSupport();
            this.PasswordCallbackSupport();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void NameCallbackSupport() {
        if (callbackHandler != null) {
            try {
                NameCallback nameCallback = new NameCallback("Please enter your name :", "j2ee");
                nameCallback.setName("j2ee");
                Callback[] callbacks = new Callback[]{nameCallback};
                callbackHandler.handle(callbacks);
                String returnedName = nameCallback.getName();
                if (returnedName != null) {
                    this.logMsg("Name returned from Name Callback =" + returnedName);
                }
                this.logMsg("CallbackHandler supports NameCallback");
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support NameCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support NameCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    private void PasswordCallbackSupport() {
        if (callbackHandler != null) {
            try {
                PasswordCallback passwordCallback = new PasswordCallback("Please enter your password :", false);
                passwordCallback.setPassword(new char[]{'j', '2', 'e', 'e'});
                Callback[] callbacks = new Callback[]{passwordCallback};
                callbackHandler.handle(callbacks);
                char[] returnedPassword = passwordCallback.getPassword();
                if (returnedPassword != null) {
                    this.logMsg("Password returned from Password Callback =" + new String(returnedPassword));
                }
                this.logMsg("CallbackHandler supports PasswordCallback");
            }
            catch (UnsupportedCallbackException usce) {
                this.logMsg("CallbackHandler failed to support PasswordCallback :" + usce.getMessage());
                usce.printStackTrace();
            }
            catch (IOException ioe) {
                this.logMsg("CallbackHandler failed to support PasswordCallback :" + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    public void logMsg(String str) {
        if (logger != null) {
            logger.log(Level.INFO, "In " + profile + " : ClientRuntime " + str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }
}

