/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testng.Reporter;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class JobOperatorTests {
    private static final Logger logger = Logger.getLogger(JobOperatorTests.class.getName());
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    @BeforeMethod
    @BeforeClass
    public static void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @AfterMethod
    public static void tearDown() throws Exception {
    }

    private void begin(String str) {
        Reporter.log((String)("Begin test method: " + str));
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorStart() throws Exception {
        String METHOD = "testJobOperatorStart";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_1step.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorRestart() throws Exception {
        String METHOD = "testJobOperatorRestart";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.next.writepoints=10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)("Invoke restartJobAndWaitForResult for execution id: " + lastExecutionId + "<p>"));
            exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorRestartAlreadyCompleteException() throws Exception {
        String METHOD = "testJobOperatorRestartAlreadyCompleteException";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.next.writepoints=10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long firstExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + firstExecutionId + "<p>"));
            Reporter.log((String)("Invoke restartJobAndWaitForResult for execution id: " + firstExecutionId + "<p>"));
            exec = jobOp.restartJobAndWaitForResult(firstExecutionId, jobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
            long secondExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 Job execution id=" + secondExecutionId + "<p>"));
            Reporter.log((String)("Now invoke restart again, expecting JobExecutionAlreadyCompleteException, for execution id: " + secondExecutionId + "<p>"));
            boolean seenException = false;
            try {
                jobOp.restartJobAndWaitForResult(secondExecutionId, jobParams);
            }
            catch (JobExecutionAlreadyCompleteException e) {
                Reporter.log((String)"Caught JobExecutionAlreadyCompleteException as expected<p>");
                seenException = true;
            }
            AssertionUtils.assertWithMessage("Caught JobExecutionAlreadyCompleteException for bad restart #2", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorAbandonJobDuringARestart() throws Exception {
        String METHOD = "testJobOperatorAbandonJobDuringARestart";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "5000";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            Reporter.log((String)"execution.number=1<p>");
            String sleepTime = System.getProperty("JobOperatorTests.testJobOperatorTestAbandonActiveRestart.sleep", DEFAULT_SLEEP_TIME);
            jobParams.put("sleep.time", sleepTime);
            Reporter.log((String)("sleep.time=" + sleepTime + "<p>"));
            Reporter.log((String)"Locate job XML file: abandonActiveRestart.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("abandonActiveRestart", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long firstExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + firstExecutionId + "<p>"));
            jobParams = new Properties();
            jobParams.put("execution.number", "2");
            Reporter.log((String)"execution.number=2<p>");
            sleepTime = System.getProperty("JobOperatorTests.testJobOperatorTestAbandonActiveRestart.sleep", DEFAULT_SLEEP_TIME);
            jobParams.put("sleep.time", sleepTime);
            Reporter.log((String)("sleep.time=" + sleepTime + "<p>"));
            Reporter.log((String)("Invoke restartJobWithoutWaitingForResult for execution id: " + firstExecutionId + "<p>"));
            exec = jobOp.restartJobWithoutWaitingForResult(firstExecutionId, jobParams);
            long secondExecutionId = exec.getExecutionId();
            Reporter.log((String)("Invoke restartJobAndWaitForResult for execution id: " + firstExecutionId + "<p>"));
            boolean seen = false;
            try {
                jobOp.abandonJobExecution(secondExecutionId);
            }
            catch (JobExecutionIsRunningException jobRunningEx) {
                Reporter.log((String)"Caught JobExecutionIsRunningException as expected<p>");
                seen = true;
            }
            AssertionUtils.assertWithMessage("Did not see expected JobExecutionIsRunningException for abandon attempt during restart", seen);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorRestartJobAlreadyAbandoned() throws Exception {
        String METHOD = "testJobOperatorRestartAlreadyCompleteException";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "1";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            Reporter.log((String)"execution.number=1<p>");
            String sleepTime = System.getProperty("JobOperatorTests.testJobOperatorTestRestartAlreadAbandonedJob.sleep", DEFAULT_SLEEP_TIME);
            jobParams.put("sleep.time", sleepTime);
            Reporter.log((String)("sleep.time=" + sleepTime + "<p>"));
            Reporter.log((String)"Locate job XML file: abandonActiveRestart.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("abandonActiveRestart", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long firstExecutionId = execution1.getExecutionId();
            jobOp.abandonJobExecution(firstExecutionId);
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + firstExecutionId + "<p>"));
            jobParams = new Properties();
            jobParams.put("execution.number", "2");
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)("Invoke restartJobWithoutWaitingForResult for execution id: " + firstExecutionId + "<p>"));
            Reporter.log((String)("Invoke restartJobAndWaitForResult for execution id: " + firstExecutionId + "<p>"));
            boolean seen = false;
            try {
                jobOp.restartJobWithoutWaitingForResult(firstExecutionId, jobParams);
            }
            catch (JobRestartException jobRestartEx) {
                Reporter.log((String)"Caught JobRestartException as expected<p>");
                seen = true;
            }
            AssertionUtils.assertWithMessage("Caught JobRestartException for abandon attempt during restart", seen);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testInvokeJobWithUserStop() throws Exception {
        String METHOD = "testInvokeJobWithUserStop";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "1000";
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_longrunning.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParameters = new Properties();
            Reporter.log((String)"run.indefinitely=true<p>");
            jobParameters.setProperty("run.indefinitely", "true");
            Reporter.log((String)"Invoking startJobWithoutWaitingForResult for Execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning", jobParameters);
            int sleepTime = Integer.parseInt(System.getProperty("JobOperatorTests.testInvokeJobWithUserStop.sleep", "1000"));
            Reporter.log((String)("Thread.sleep(" + sleepTime + ")<p>"));
            Thread.sleep(sleepTime);
            Reporter.log((String)"Invoking stopJobAndWaitForResult for Execution #1<p>");
            jobOp.stopJobAndWaitForResult(jobExec);
            JobExecution jobExec2 = jobOp.getJobExecution(jobExec.getExecutionId());
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec2.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorGetStepExecutions() throws Exception {
        String METHOD = "testJobOperatorGetStepExecutions";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_1step.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + "<p>"));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, stepExecutions.size());
            for (StepExecution step : stepExecutions) {
                this.showStepState(step);
                Reporter.log((String)("Step status=" + step.getBatchStatus() + "<p>"));
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, step.getBatchStatus());
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOpGetJobNames() throws Exception {
        String METHOD = "testJobOpGetJobNames";
        this.begin(METHOD);
        String jobName = "job_unique_get_job_names";
        try {
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            List<String> jobNames = jobOp.getJobNames();
            jobOp.startJobWithoutWaitingForResult("job_unique_get_job_names");
            if (jobNames.contains(jobName)) {
                Reporter.log((String)("JobOperator.getJobNames() already includes " + jobName + ", test is not so useful<p>"));
            } else {
                Reporter.log((String)("JobOperator.getJobNames() does not include " + jobName + " yet.<p>"));
            }
            jobNames = jobOp.getJobNames();
            AssertionUtils.assertWithMessage("Now JobOperator.getJobNames() definitely includes " + jobName, jobNames.contains(jobName));
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testAbandoned() throws Exception {
        String METHOD = "testAbandoned";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_batchlet_4steps.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_4steps");
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
            jobOp.abandonJobExecution(jobExec.getExecutionId());
            JobExecution jobExec2 = jobOp.getJobExecution(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(BatchStatus.ABANDONED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOpgetJobInstanceCount() throws Exception {
        String METHOD = "testJobOpgetJobInstanceCount";
        this.begin(METHOD);
        try {
            int countTrackerBEFORE = 0;
            try {
                countTrackerBEFORE = jobOp.getJobInstanceCount("chunksize5commitinterval5");
            }
            catch (NoSuchJobException noSuchJobException) {
                // empty catch block
            }
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.faile=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            int countTrackerAFTER = jobOp.getJobInstanceCount("chunksize5commitinterval5");
            AssertionUtils.assertWithMessage("job count for job1 increased by 1", 1, countTrackerAFTER - countTrackerBEFORE);
            List<String> jobNames = jobOp.getJobNames();
            for (String jobname : jobNames) {
                Reporter.log((String)(jobname + " instance count : " + jobOp.getJobInstanceCount(jobname) + " - "));
            }
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOpgetJobInstanceCountException() throws Exception {
        String METHOD = "testJobOpgetJobInstanceCountException";
        this.begin(METHOD);
        try {
            int countTrackerBEFORE = 0;
            try {
                countTrackerBEFORE = jobOp.getJobInstanceCount("ChunkStopOnEndOn");
            }
            catch (NoSuchJobException noSuchJobException) {
                // empty catch block
            }
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.faile=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            boolean seenException = false;
            try {
                int n = jobOp.getJobInstanceCount("NoSuchJob");
            }
            catch (NoSuchJobException noJobEx) {
                Reporter.log((String)"Confirmed we caught NoSuchJobException<p>");
                seenException = true;
            }
            AssertionUtils.assertWithMessage("Saw NoSuchJobException for job 'NoSuchJob'", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOpgetJobInstances() throws Exception {
        String METHOD = " testJobOpgetJobInstances";
        this.begin(METHOD);
        int submitTimes = 10;
        try {
            int countTrackerBEFORE = 0;
            int countTrackerAFTER = 0;
            try {
                countTrackerBEFORE = jobOp.getJobInstanceCount("chunksize5commitinterval5");
                Reporter.log((String)("Before test ran the JobInstance count for chunksize5commitinterval5 was " + countTrackerBEFORE + "<p>"));
            }
            catch (NoSuchJobException e) {
                Reporter.log((String)"Not an error, but just the first time executing this job <p>");
            }
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.faile=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            for (int i = 0; i < submitTimes; ++i) {
                jobOp.startJobWithoutWaitingForResult("chunksize5commitinterval5", jobParams);
            }
            List<JobInstance> jobInstances = null;
            try {
                jobInstances = jobOp.getJobInstances("chunksize5commitinterval5", 0, 10);
                countTrackerAFTER = jobOp.getJobInstanceCount("chunksize5commitinterval5");
                AssertionUtils.assertWithMessage("Check that we see: " + submitTimes + " new submissions", submitTimes, countTrackerAFTER - countTrackerBEFORE);
            }
            catch (NoSuchJobException noJobEx) {
                Reporter.log((String)"Failing test, caught NoSuchJobException<p>");
                throw noJobEx;
            }
            Reporter.log((String)("Size of Job Instances list = " + jobInstances.size() + "<p>"));
            AssertionUtils.assertWithMessage("Testing that a list of Job Instances were obtained", 10, jobInstances.size());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOpgetJobInstancesException() throws Exception {
        String METHOD = "testJobOpgetJobInstancesException";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.faile=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: /chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            List<JobInstance> jobIds = null;
            boolean seenException = false;
            try {
                jobIds = jobOp.getJobInstances("NoSuchJob", 0, 12);
            }
            catch (NoSuchJobException noJobEx) {
                seenException = true;
                Reporter.log((String)"Confirmed we caught NoSuchJobException<p>");
            }
            AssertionUtils.assertWithMessage("Saw NoSuchJobException for job 'NoSuchJob'", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorGetParameters() throws Exception {
        String METHOD = "testJobOperatorGetParameters";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties originalJobParams = new Properties();
            Properties restartJobParams = null;
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.next.writepoints=10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            originalJobParams.put("execution.number", "1");
            originalJobParams.put("readrecord.fail", "12");
            originalJobParams.put("app.arraysize", "30");
            originalJobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            originalJobParams.put("app.next.writepoints", "10,15,20,25,30");
            originalJobParams.put("app.commitinterval", "5");
            String N1 = "extra.parm.name1";
            String V1 = "extra.parm.value1";
            String N2 = "extra.parm.name2";
            String V2 = "extra.parm.value2";
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", originalJobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper execution2 = null;
            Reporter.log((String)("Got Job instance id: " + jobInstanceId + "<p>"));
            Reporter.log((String)("Got Job execution id: " + lastExecutionId + "<p>"));
            Reporter.log((String)"Invoke clone original job execution parameters<p>");
            restartJobParams = (Properties)originalJobParams.clone();
            Reporter.log((String)"Put some extra parms in the restart execution<p>");
            restartJobParams.put(N1, V1);
            restartJobParams.put(N2, V2);
            Reporter.log((String)("Invoke restartJobAndWaitForResult for execution id: " + lastExecutionId + "<p>"));
            execution2 = jobOp.restartJobAndWaitForResult(lastExecutionId, restartJobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + execution2.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", execution2.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, execution2.getInstanceId());
            Properties jobParamsFromJobOperator = jobOp.getParameters(execution1.getExecutionId());
            Properties jobParamsFromJobExecution = execution1.getJobParameters();
            AssertionUtils.assertWithMessage("Comparing original job params with jobOperator.getParameters", originalJobParams, jobParamsFromJobOperator);
            Reporter.log((String)"JobOperator.getParameters() matches for original execution <p>");
            AssertionUtils.assertWithMessage("Comparing original job params with jobExecution.getParameters", originalJobParams, jobParamsFromJobExecution);
            Reporter.log((String)"JobExecution.getParameters() matches for original execution <p>");
            Properties restartJobParamsFromJobOperator = jobOp.getParameters(execution2.getExecutionId());
            Properties restartJobParamsFromJobExecution = execution2.getJobParameters();
            AssertionUtils.assertWithMessage("Comparing restart job params with jobOperator.getParameters", restartJobParams, restartJobParamsFromJobOperator);
            Reporter.log((String)"JobOperator.getParameters() matches for restart execution <p>");
            AssertionUtils.assertWithMessage("Comparing restart job params with jobExecution.getParameters", restartJobParams, restartJobParamsFromJobExecution);
            Reporter.log((String)"JobExecution.getParameters() matches for restart execution <p>");
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorGetJobInstances() throws Exception {
        String METHOD = "testJobOperatorGetJobInstances";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=31<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "COMPLETED", execution1.getExitStatus());
            Reporter.log((String)"Create job parameters for execution #2:<p>");
            jobParams = new Properties();
            Reporter.log((String)"execution.number=2<p>");
            Reporter.log((String)"readrecord.fail=31<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #2<p>");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", execution2.getExitStatus());
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #3<p>");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #3 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #3 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #3", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3", "COMPLETED", execution3.getExitStatus());
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #4<p>");
            TCKJobExecutionWrapper execution4 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #4 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #4 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #4", BatchStatus.COMPLETED, execution4.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #4", "COMPLETED", execution4.getExitStatus());
            List<JobInstance> jobInstances012 = jobOp.getJobInstances("chunksize5commitinterval5", 0, 3);
            List<JobInstance> jobInstances123 = jobOp.getJobInstances("chunksize5commitinterval5", 1, 3);
            for (int i = 0; i < 3; ++i) {
                logger.fine("AJM: instance id012[" + i + "] = " + jobInstances012.get(i).getInstanceId());
                logger.fine("AJM: instance id123[" + i + "] = " + jobInstances123.get(i).getInstanceId());
            }
            AssertionUtils.assertWithMessage("job instances should not be equal", jobInstances012.get(0).getInstanceId() != jobInstances123.get(0).getInstanceId());
            AssertionUtils.assertWithMessage("job instances should be equal", jobInstances012.get(1).getInstanceId() == jobInstances123.get(0).getInstanceId());
            AssertionUtils.assertWithMessage("job instances should be equal", jobInstances012.get(2).getInstanceId() == jobInstances123.get(1).getInstanceId());
            AssertionUtils.assertWithMessage("job instances should not be equal", jobInstances012.get(2).getInstanceId() != jobInstances123.get(2).getInstanceId());
            Reporter.log((String)("Size of jobInstancesList = " + jobInstances012.size() + "<p>"));
            Reporter.log((String)("Testing retrieval of the JobInstances list, size = " + jobInstances012.size() + "<p>"));
            AssertionUtils.assertWithMessage("Testing retrieval of the JobInstances list", jobInstances012.size() > 0);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorGetRunningJobExecutions() throws Exception {
        String METHOD = "testJobOperatorGetRunningJobExecutions";
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "1000";
        String DEFAULT_APP_TIME_INTERVAL = "10000";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            String timeinterval = System.getProperty("JobOperatorTests.testJobOperatorGetRunningJobExecutions.app.timeinterval", "10000");
            jobParams.put("app.timeinterval", timeinterval);
            Reporter.log((String)"Invoke startJobWithoutWaitingForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", jobParams);
            Properties newJobParameters = new Properties();
            newJobParameters.put("app.timeinterval", timeinterval);
            Reporter.log((String)"Invoke startJobWithoutWaitingForResult<p>");
            TCKJobExecutionWrapper exec = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", newJobParameters);
            int sleepTime = Integer.parseInt(System.getProperty("ExecutionTests.testJobOperatorGetRunningJobExecutions.sleep", "1000"));
            Reporter.log((String)("Thread.sleep(" + sleepTime + ")<p>"));
            Thread.sleep(sleepTime);
            List<Long> jobExecutions = jobOp.getRunningExecutions("job_batchlet_step_listener");
            AssertionUtils.assertWithMessage("Found job instances in the RUNNING state", jobExecutions.size() > 0);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorGetRunningJobInstancesException() throws Exception {
        String METHOD = "testJobOperatorGetRunningJobInstancesException";
        this.begin(METHOD);
        String DEFAULT_APP_TIME_INTERVAL = "10000";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            String timeinterval = System.getProperty("JobOperatorTests.testJobOperatorGetRunningJobInstancesException.app.timeinterval", "10000");
            jobParams.put("app.timeinterval", timeinterval);
            Reporter.log((String)"Invoke startJobWithoutWaitingForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", jobParams);
            Properties restartJobParameters = new Properties();
            restartJobParameters.put("app.timeinterval", timeinterval);
            Reporter.log((String)"Invoke startJobWithoutWaitingForResult");
            TCKJobExecutionWrapper exec = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", restartJobParameters);
            boolean seenException = false;
            try {
                Reporter.log((String)"Check for an instance of a non-existent job<p>");
                jobOp.getRunningExecutions("JOBNAMEDOESNOTEXIST");
            }
            catch (NoSuchJobException e) {
                Reporter.log((String)"Confirmed that exception caught is an instanceof NoSuchJobException<p>");
                seenException = true;
            }
            AssertionUtils.assertWithMessage("Saw NoSuchJobException for job 'JOBNAMEDOESNOTEXIST'", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorGetJobExecution() throws Exception {
        String METHOD = "testJobOperatorGetJobExecution";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=12<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.writepoints=0,5,10,15,20,25,30<p>");
            Reporter.log((String)"app.next.writepoints=10,15,20,25,30<p>");
            Reporter.log((String)"app.commitinterval=5<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            Reporter.log((String)("Invoke restartJobAndWaitForResult for execution id: " + lastExecutionId + "<p>"));
            exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + exec.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
            Reporter.log((String)"Testing retrieval of a JobExecution obj");
            JobExecution jobEx = jobOp.getJobExecution(lastExecutionId);
            Reporter.log((String)("Status retreived from JobExecution obj: " + jobEx.getBatchStatus() + "<p>"));
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    @org.testng.annotations.Test
    @Test
    public void testJobOperatorGetJobExecutions() throws Exception {
        String METHOD = "testJobOperatorGetJobExecutions";
        this.begin(METHOD);
        String jobName = "chunksize5commitinterval5";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            Reporter.log((String)"Locate job XML file: chunksize5commitinterval5.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult(jobName, jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long execution1ID = execution1.getExecutionId();
            TCKJobExecutionWrapper execution2 = null;
            Reporter.log((String)("Invoke restartJobAndWaitForResult for execution id: " + execution1ID + "<p>"));
            execution2 = jobOp.restartJobAndWaitForResult(execution1ID, jobParams);
            Reporter.log((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus() + "<p>"));
            Reporter.log((String)("execution #2 Job instance id=" + execution2.getInstanceId() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", execution2.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #1 and execution #2 use the same instanceId", execution1.getInstanceId(), execution2.getInstanceId());
            long execution2ID = execution2.getExecutionId();
            JobInstance jobInstance = jobOp.getJobInstance(execution2ID);
            List<JobExecution> jobExecutions = jobOp.getJobExecutions(jobInstance);
            AssertionUtils.assertWithMessage("Testing list size of JobExecutions", 2, jobExecutions.size());
            boolean seen1 = false;
            boolean seen2 = false;
            for (JobExecution je : jobExecutions) {
                if (je.getExecutionId() == execution1ID) {
                    AssertionUtils.assertWithMessage("Dup of execution 1", !seen1);
                    Reporter.log((String)"Seen execution #1 <p>");
                    seen1 = true;
                    continue;
                }
                if (je.getExecutionId() != execution2ID) continue;
                AssertionUtils.assertWithMessage("Dup of execution 2", !seen2);
                Reporter.log((String)"Seen execution #2 <p>");
                seen2 = true;
            }
            AssertionUtils.assertWithMessage("Seen both of the two JobExecutions", seen1 && seen2);
            AssertionUtils.assertWithMessage("Job name from JobInstance matches", jobName, jobInstance.getJobName());
            AssertionUtils.assertWithMessage("Job name from JobExecution 1 matches", jobName, execution1.getJobName());
            AssertionUtils.assertWithMessage("Job name from JobExecution 2 matches", jobName, execution2.getJobName());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    private void showStepState(StepExecution step) {
        Reporter.log((String)"---------------------------");
        Reporter.log((String)("getStepName(): " + step.getStepName() + " - "));
        Reporter.log((String)("getJobExecutionId(): " + step.getStepExecutionId() + " - "));
        Metric[] metrics = step.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            Reporter.log((String)(metrics[i].getType() + ": " + metrics[i].getValue() + " - "));
        }
        Reporter.log((String)("getStartTime(): " + step.getStartTime() + " - "));
        Reporter.log((String)("getEndTime(): " + step.getEndTime() + " - "));
        Reporter.log((String)("getBatchStatus(): " + step.getBatchStatus() + " - "));
        Reporter.log((String)("getExitStatus(): " + step.getExitStatus()));
        Reporter.log((String)"---------------------------");
    }
}

