/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class RetryConnectionHelper {
    private static final String CLASSNAME = RetryConnectionHelper.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    public static final String jndiName = "jdbc/orderDB";
    public static final String INSERT_NUMBERS = "insert into app.numbers values(?, ?)";
    public static final String UPDATE_NUMBERS = "update app.numbers set quantity = ? where item = ?";
    public static final String SELECT_NUMBERS = "select item, quantity from app.numbers where item = ?";

    public static Connection getConnection(DataSource dataSource) throws SQLException {
        Connection conn = dataSource.getConnection();
        return conn;
    }

    public static Connection getConnection(DataSource dataSource, boolean autoCommit) throws SQLException {
        Connection conn = dataSource.getConnection();
        conn.setAutoCommit(autoCommit);
        return conn;
    }

    public static void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.entering(CLASSNAME, "cleanupConnection", new Object[]{conn, rs, statement});
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        logger.exiting(CLASSNAME, "cleanupConnection");
    }
}

