/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ContextsGetIdTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @Test
    public void testJobContextGetId() throws Exception {
        String METHOD = "testJobContextGetId";
        try {
            String jobId = "job1";
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("contexts_getid_jobcontext", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("job id equals job1", jobId, jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            ContextsGetIdTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testStepContextGetId() throws Exception {
        String METHOD = "testStepContextGetId";
        try {
            String stepId = "step1";
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("contexts_getid_stepcontext", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("job id equals job1", stepId, jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            ContextsGetIdTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

