/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.RetryConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemWriter;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="retryWriter")
public class RetryWriter
extends AbstractItemWriter {
    protected DataSource dataSource = null;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="forced.fail.count.write")
    String forcedFailCountProp;
    @Inject
    @BatchProperty(name="rollback")
    String rollbackProp;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RETRY = 1;
    private static final int STATE_SKIP = 2;
    private static final int STATE_EXCEPTION = 3;
    private int testState = 0;
    int forcedFailCount = 0;
    boolean isInited = false;
    boolean rollback;
    int count = 1;

    public void open(Serializable cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
    }

    public void writeItems(List<Object> records) throws Exception {
        int item = -1;
        int quantity = -1;
        int check = -1;
        if (!this.isInited) {
            this.forcedFailCount = Integer.parseInt(this.forcedFailCountProp);
            this.rollback = Boolean.parseBoolean(this.rollbackProp);
            this.isInited = true;
        }
        for (Object record : records) {
            item = ((NumbersRecord)record).getItem();
            quantity = ((NumbersRecord)record).getQuantity();
            Reporter.log((String)("Writing item: " + item + "...<br>"));
            if (this.forcedFailCount != 0 && this.count >= this.forcedFailCount && this.testState == 0) {
                this.testState = 1;
                Reporter.log((String)"Fail on purpose in NumbersRecord.writeItems<p>");
                throw new MyParentException("Fail on purpose in NumbersRecord.writeItems()");
            }
            if (this.forcedFailCount != 0 && this.count > this.forcedFailCount && this.testState == 3) {
                this.testState = 2;
                this.forcedFailCount = 0;
                Reporter.log((String)"Test skip -- Fail on purpose NumbersRecord.writeItems<p>");
                throw new MyParentException("Test skip -- Fail on purpose in NumbersRecord.writeItems()");
            }
            if (this.testState == 1) {
                if (((Properties)this.stepCtx.getTransientUserData()).getProperty("retry.write.exception.invoked") != "true") {
                    Reporter.log((String)"onRetryWriteException not invoked<p>");
                    throw new Exception("onRetryWriteException not invoked");
                }
                Reporter.log((String)"onRetryWriteException was invoked<p>");
                if (((Properties)this.stepCtx.getTransientUserData()).getProperty("retry.write.exception.match") != "true") {
                    Reporter.log((String)"retryable exception does not match");
                    throw new Exception("retryable exception does not match");
                }
                Reporter.log((String)"retryable exception matches");
                this.testState = 3;
            } else if (this.testState == 2) {
                if (((Properties)this.stepCtx.getTransientUserData()).getProperty("skip.write.item.invoked") != "true") {
                    Reporter.log((String)"onSkipWriteItem not invoked<p>");
                    throw new Exception("onSkipWriteItem not invoked");
                }
                Reporter.log((String)"onSkipWriteItem was invoked<p>");
                if (((Properties)this.stepCtx.getTransientUserData()).getProperty("skip.write.item.match") != "true") {
                    Reporter.log((String)"skippable exception does not match<p>");
                    throw new Exception("skippable exception does not match");
                }
                Reporter.log((String)"skippable exception matches<p>");
                this.testState = 0;
            }
            Connection connection = null;
            PreparedStatement statement = null;
            try {
                connection = RetryConnectionHelper.getConnection(this.dataSource);
                statement = connection.prepareStatement("update app.numbers set quantity = ? where item = ?");
                statement.setInt(2, item);
                statement.setInt(1, quantity);
                Reporter.log((String)("Write [item: " + item + " quantity: " + quantity + "]<p>"));
                int rs = statement.executeUpdate();
                ++this.count;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    RetryConnectionHelper.cleanupConnection(connection, null, statement);
                    throw throwable;
                }
            }
            RetryConnectionHelper.cleanupConnection(connection, null, statement);
        }
    }
}

