/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.AbstractBatchlet;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Random;
import java.util.logging.Logger;

@Named(value="startLimitStateMachineVariation2Batchlet")
public class StartLimitStateMachineVariation2Batchlet
extends AbstractBatchlet {
    private static final String sourceClass = StartLimitStateMachineVariation2Batchlet.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final String JSL_STOP_TRANSITION = "JSL.STOP";
    private static final String JSL_FAIL_TRANSITION = "JSL.FAIL";
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="runNumber")
    String runNumberString;

    public String process() throws Exception {
        logger.fine(sourceClass + ".process()");
        Random r = new Random();
        int x = r.nextInt();
        int y = r.nextInt();
        for (int i = 0; i < 10; ++i) {
            x = y * x % 3469;
            y = x * y % 3491;
        }
        String exitStatus = null;
        try {
            exitStatus = this.contributeToExitStatus();
            this.appendToJobContext(exitStatus);
        }
        catch (FailViaException e) {
            logger.fine(sourceClass + ".process(); Exiting with exitStatus = " + exitStatus);
            String errorAppend = (String)this.jobCtx.getTransientUserData();
            this.appendToJobContext(errorAppend);
            throw new RuntimeException("Throwing exception on purpose");
        }
        logger.fine(sourceClass + ".process(); exitStatus = " + exitStatus);
        if (exitStatus.startsWith("s")) {
            logger.fine("For step exitStatus for step: " + this.stepCtx.getStepName() + " , return: JSL.STOP");
            return JSL_STOP_TRANSITION;
        }
        if (exitStatus.startsWith("f")) {
            logger.fine("For step exitStatus for step: " + this.stepCtx.getStepName() + " , return: JSL.FAIL");
            return JSL_FAIL_TRANSITION;
        }
        logger.fine("For step exitStatus for step: " + this.stepCtx.getStepName() + " , don't return value");
        return null;
    }

    private void appendToJobContext(String exitStatus) {
        String es = this.jobCtx.getExitStatus();
        if (es == null) {
            logger.fine("First addition to Job ExitStatus = " + es);
            this.jobCtx.setExitStatus(exitStatus);
        } else {
            String newExitStatus = es.concat(",").concat(exitStatus);
            logger.fine("Existing Job ExitStatus = " + es + " ; Updating to : " + newExitStatus);
            this.jobCtx.setExitStatus(newExitStatus);
        }
    }

    public void stop() throws Exception {
        logger.fine(sourceClass + ".cancel()");
    }

    private String contributeToExitStatus() throws FailViaException {
        logger.fine(sourceClass + ".calculateExitStatus(), runNumberString = " + this.runNumberString);
        int execNum = Integer.parseInt(this.runNumberString.substring(new String("runNumber.").length()));
        String stepId = this.stepCtx.getStepName();
        logger.fine(sourceClass + ".calculateExitStatus(), execution # = " + execNum + ", stepId = " + stepId);
        if (stepId.equals("step1")) {
            switch (execNum) {
                case 1: {
                    return "c1";
                }
                case 2: {
                    return "c1";
                }
                case 3: {
                    return "c1";
                }
                case 4: {
                    return "c1";
                }
                case 5: {
                    return "ILLEGAL.STATE";
                }
                case 6: {
                    return "c1";
                }
                case 7: {
                    return "c1";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step2")) {
            switch (execNum) {
                case 1: {
                    return "c2";
                }
                case 2: {
                    return "c2";
                }
                case 3: {
                    return "c2";
                }
                case 4: {
                    return "c2";
                }
                case 5: {
                    return "ILLEGAL.STATE";
                }
                case 6: {
                    return "c2";
                }
                case 7: {
                    return "c2";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step3")) {
            switch (execNum) {
                case 1: {
                    throw new FailViaException();
                }
                case 2: {
                    throw new FailViaException();
                }
                case 3: {
                    return "s3";
                }
                case 4: {
                    return "ILLEGAL.STATE";
                }
                case 5: {
                    return "ILLEGAL.STATE";
                }
                case 6: {
                    return "ILLEGAL.STATE";
                }
                case 7: {
                    return "ILLEGAL.STATE";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step4")) {
            switch (execNum) {
                case 1: {
                    return "ILLEGAL.STATE";
                }
                case 2: {
                    return "ILLEGAL.STATE";
                }
                case 3: {
                    return "ILLEGAL.STATE";
                }
                case 4: {
                    return "s4";
                }
                case 5: {
                    return "f4";
                }
                case 6: {
                    return "c4";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step5")) {
            switch (execNum) {
                case 6: {
                    return "f5";
                }
            }
            return "ILLEGAL.STATE";
        }
        return "ILLEGAL.STATE";
    }

    private class FailViaException
    extends Exception {
        private FailViaException() {
        }
    }
}

