/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.io.File;
import java.nio.file.Path;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.VisibleForTesting;

public class ShouldExist
extends BasicErrorMessageFactory {
    @VisibleForTesting
    public static final String PATH_SHOULD_EXIST = "%nExpecting path:%n  %s%nto exist (symbolic links were followed).";
    public static final String PATH_SHOULD_EXIST_NO_FOLLOW_LINKS = "%nExpecting path:%n  %s%nto exist (symbolic links were not followed).";
    public static final String FILE_SHOULD_EXIST = "%nExpecting file:%n  %s%nto exist.";

    public static ErrorMessageFactory shouldExist(File actual) {
        return new ShouldExist(actual);
    }

    public static ErrorMessageFactory shouldExist(Path actual) {
        return new ShouldExist(actual, true);
    }

    public static ErrorMessageFactory shouldExistNoFollowLinks(Path actual) {
        return new ShouldExist(actual, false);
    }

    private ShouldExist(File actual) {
        super(FILE_SHOULD_EXIST, actual);
    }

    private ShouldExist(Path actual, boolean followLinks) {
        super(followLinks ? PATH_SHOULD_EXIST : PATH_SHOULD_EXIST_NO_FOLLOW_LINKS, actual);
    }
}

