/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.inheritance.specialization.producer.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Expensive;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Necklace;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Product;
import org.jboss.cdi.tck.tests.inheritance.specialization.producer.method.Sparkly;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ProducerMethodSpecializationTest
extends AbstractTest {
    private static Annotation EXPENSIVE_LITERAL = new AnnotationLiteral<Expensive>(){};
    private static Annotation SPARKLY_LITERAL = new AnnotationLiteral<Sparkly>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerMethodSpecializationTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization", id="ia"), @SpecAssertion(section="direct_and_indirect_specialization", id="k"), @SpecAssertion(section="direct_and_indirect_specialization", id="j"), @SpecAssertion(section="producer_or_disposer_methods_invocation", id="c"), @SpecAssertion(section="specialize_producer_method", id="aa")})
    public void testSpecializingProducerMethod() {
        Set<Bean<Necklace>> expensiveNecklaceBeans = this.getBeans(Necklace.class, EXPENSIVE_LITERAL);
        Assert.assertEquals((int)expensiveNecklaceBeans.size(), (int)1);
        Bean<Necklace> expensiveNecklaceBean = expensiveNecklaceBeans.iterator().next();
        Set expensiveNecklaceBeanTypes = expensiveNecklaceBean.getTypes();
        Assert.assertEquals((int)expensiveNecklaceBeanTypes.size(), (int)3);
        Assert.assertTrue((boolean)this.typeSetMatches(expensiveNecklaceBeanTypes, new Type[]{Object.class, Product.class, Necklace.class}));
        Set expensiveNecklaceQualifiers = expensiveNecklaceBean.getQualifiers();
        Assert.assertEquals((int)expensiveNecklaceQualifiers.size(), (int)4);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)expensiveNecklaceQualifiers, Expensive.class, Sparkly.class, Any.class, Named.class));
        Set<Bean<Necklace>> sparklyNecklaceBeans = this.getBeans(Necklace.class, SPARKLY_LITERAL);
        Assert.assertEquals((int)sparklyNecklaceBeans.size(), (int)1);
        Bean<Necklace> sparklyBean = sparklyNecklaceBeans.iterator().next();
        Assert.assertEquals((String)sparklyBean.getName(), (String)"expensiveGift");
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="direct_and_indirect_specialization", id="ia")})
    public void testSpecializingBeanInjection(@Expensive Product product) {
        Assert.assertTrue((boolean)(product instanceof Necklace));
        Assert.assertEquals((int)product.getPrice(), (int)10);
    }
}

