/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.beanContainer;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.RetentionLiteral;
import org.jboss.cdi.tck.literals.TargetLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.beanContainer.AnimalStereotype;
import org.jboss.cdi.tck.tests.beanContainer.Dog;
import org.jboss.cdi.tck.tests.beanContainer.Food;
import org.jboss.cdi.tck.tests.beanContainer.Soy;
import org.jboss.cdi.tck.tests.beanContainer.Tame;
import org.jboss.cdi.tck.tests.beanContainer.Terrier;
import org.jboss.cdi.tck.tests.beanContainer.Transactional;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class BeanContainerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanContainerTest.class)).withClasses(RetentionLiteral.class, TargetLiteral.class)).build();
    }

    @Test
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="a")
    public void testAmbiguousDependencyResolved() {
        Set beans = this.getCurrentBeanContainer().getBeans(Food.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)2);
        Bean bean = this.getCurrentBeanContainer().resolve(beans);
        Assert.assertNotNull((Object)bean);
        Assert.assertTrue((boolean)bean.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Food.class, Soy.class, Object.class}));
    }

    @Test(expectedExceptions={AmbiguousResolutionException.class})
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="b")
    public void testAmbiguousDependencyNotResolved() {
        HashSet beans = new HashSet();
        beans.addAll(this.getCurrentBeanContainer().getBeans(Dog.class, new Annotation[0]));
        beans.addAll(this.getCurrentBeanContainer().getBeans(Terrier.class, new Annotation[0]));
        this.getCurrentBeanContainer().resolve(beans);
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="aa")
    public void testDetermineQualifierType() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isQualifier(Any.class));
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isQualifier(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isQualifier(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isQualifier(ApplicationScoped.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isQualifier(Transactional.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ab")
    public void testDetermineScope() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isScope(ApplicationScoped.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isScope(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isScope(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isScope(Transactional.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ac")
    public void testDetermineStereotype() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isStereotype(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isStereotype(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isStereotype(ApplicationScoped.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isStereotype(Transactional.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ad")
    public void testDetermineInterceptorBindingType() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isInterceptorBinding(Transactional.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isInterceptorBinding(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isInterceptorBinding(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isInterceptorBinding(ApplicationScoped.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ag")
    public void testDetermineScopeType() {
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isNormalScope(RequestScoped.class));
        Assert.assertTrue((boolean)this.getCurrentBeanContainer().isNormalScope(SessionScoped.class));
        Assert.assertFalse((boolean)this.getCurrentBeanContainer().isNormalScope(Dependent.class));
    }

    @Test
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="c")
    public void testResolveWithNull() {
        Assert.assertNull((Object)this.getCurrentBeanContainer().resolve(null));
    }

    @Test
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="d")
    public void testResolveWithEmptySet() {
        Assert.assertNull((Object)this.getCurrentBeanContainer().resolve(Collections.emptySet()));
        Assert.assertNull((Object)this.getCurrentBeanContainer().resolve(new HashSet()));
    }
}

