/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.container;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.InjectLiteral;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.container.AlternativeStereotype;
import org.jboss.cdi.tck.tests.se.container.Bar;
import org.jboss.cdi.tck.tests.se.container.BarInterceptor1;
import org.jboss.cdi.tck.tests.se.container.BarInterceptor2;
import org.jboss.cdi.tck.tests.se.container.Baz;
import org.jboss.cdi.tck.tests.se.container.BazObserver;
import org.jboss.cdi.tck.tests.se.container.Circle;
import org.jboss.cdi.tck.tests.se.container.Corge;
import org.jboss.cdi.tck.tests.se.container.CorgeDecorator;
import org.jboss.cdi.tck.tests.se.container.CorgeImpl;
import org.jboss.cdi.tck.tests.se.container.Foo;
import org.jboss.cdi.tck.tests.se.container.FooProducer;
import org.jboss.cdi.tck.tests.se.container.Garply;
import org.jboss.cdi.tck.tests.se.container.Qux;
import org.jboss.cdi.tck.tests.se.container.QuxObserver;
import org.jboss.cdi.tck.tests.se.container.Shape;
import org.jboss.cdi.tck.tests.se.container.Square;
import org.jboss.cdi.tck.tests.se.container.TestExtension;
import org.jboss.cdi.tck.tests.se.container.testPackage.Apple;
import org.jboss.cdi.tck.tests.se.container.testPackage.Worm;
import org.jboss.cdi.tck.tests.se.container.testPackage.nestedPackage.Pear;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0")
public class BootstrapSEContainerTest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() {
        JavaArchive testArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(BootstrapSEContainerTest.class.getPackage())).addClasses(new Class[]{Apple.class, Worm.class, Pear.class})).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        return ClassPath.builder().add(testArchive).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_container_initializer", id="a"), @SpecAssertion(section="se_bootstrap", id="a"), @SpecAssertion(section="se_bootstrap", id="c"), @SpecAssertion(section="se_bootstrap", id="do"), @SpecAssertion(section="se_container", id="cb")})
    public void testContainerIsInitialized() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        SeContainer seContainer = seContainerInitializer.initialize();
        Assert.assertTrue((boolean)seContainer.isRunning());
        Foo foo = (Foo)seContainer.select(Foo.class, new Annotation[0]).get();
        Assert.assertNotNull((Object)foo);
        foo.ping();
        seContainer.close();
        Assert.assertFalse((boolean)seContainer.isRunning());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertions(value={@SpecAssertion(section="se_container", id="ca")})
    public void testContainerCloseMethodOnNotInitializedContainer() {
        SeContainer seContainer = this.initializeAndShutdownContainer();
        seContainer.close();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_container_initializer", id="a"), @SpecAssertion(section="se_bootstrap", id="c"), @SpecAssertion(section="se_bootstrap", id="da"), @SpecAssertion(section="se_bootstrap", id="do"), @SpecAssertion(section="se_bootstrap", id="e")})
    public void testInvocationOfInitializedMethodReturnsNewSeContainerInstance() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        SeContainer seContainer1 = seContainerInitializer.initialize();
        Assert.assertNotNull((Object)seContainer1);
        seContainer1.close();
        SeContainer seContainer2 = seContainerInitializer.initialize();
        Assert.assertNotNull((Object)seContainer2);
        seContainer2.close();
        Assert.assertNotEquals((Object)seContainer1, (Object)seContainer2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="db"), @SpecAssertion(section="se_bootstrap", id="dm"), @SpecAssertion(section="se_container", id="a"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testSyntheticArchive() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{Baz.class, Qux.class, BazObserver.class}).initialize();){
            BeanManager beanManager = seContainer.getBeanManager();
            beanManager.getEvent().select(Baz.class, new Annotation[]{Any.Literal.INSTANCE}).fire((Object)new Baz());
            beanManager.getEvent().select(Qux.class, new Annotation[]{Any.Literal.INSTANCE}).fire((Object)new Qux());
            Assert.assertNotNull((Object)((Baz)seContainer.select(Baz.class, new Annotation[0]).get()).ping());
            Assert.assertTrue((boolean)BazObserver.isNotified);
            Assert.assertFalse((boolean)QuxObserver.isNotified);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_container_initializer", id="a"), @SpecAssertion(section="se_bootstrap", id="db"), @SpecAssertion(section="se_bootstrap", id="dh"), @SpecAssertion(section="se_bootstrap", id="di"), @SpecAssertion(section="se_bootstrap", id="dm"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAlternativesInSE() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{Square.class, Circle.class, Foo.class, FooProducer.class}).selectAlternatives(new Class[]{Circle.class}).selectAlternativeStereotypes(new Class[]{AlternativeStereotype.class}).initialize();){
            Shape shape = (Shape)seContainer.select(Shape.class, new Annotation[0]).get();
            Assert.assertEquals((String)shape.name(), (String)Circle.NAME);
            Set foos = seContainer.getBeanManager().getBeans(Foo.class, new Annotation[0]);
            Optional<Bean> alternativeFoo = foos.stream().filter(bean -> bean.isAlternative()).findAny();
            Assert.assertTrue((boolean)alternativeFoo.isPresent());
            Assert.assertEquals((String)alternativeFoo.get().getName(), (String)"createFoo");
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="dc"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAddPackageNotRecursively() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addPackages(new Package[]{Apple.class.getPackage()}).initialize();){
            Instance appleInstance = seContainer.select(Apple.class, new Annotation[0]);
            Instance pearInstance = seContainer.select(Pear.class, new Annotation[0]);
            Assert.assertFalse((boolean)appleInstance.isUnsatisfied());
            Assert.assertTrue((boolean)pearInstance.isUnsatisfied());
            Assert.assertNotNull((Object)((Apple)appleInstance.get()).getWorm());
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="dc"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAddPackageRecursively() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addPackages(true, new Package[]{Apple.class.getPackage()}).initialize();){
            Instance appleInstance = seContainer.select(Apple.class, new Annotation[0]);
            Instance pearInstance = seContainer.select(Pear.class, new Annotation[0]);
            Assert.assertFalse((boolean)appleInstance.isUnsatisfied());
            Assert.assertFalse((boolean)pearInstance.isUnsatisfied());
            Assert.assertNotNull((Object)((Apple)appleInstance.get()).getWorm());
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="de"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAddExtensionAsExtensionInstance() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        TestExtension testExtension = new TestExtension();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{Foo.class}).addExtensions(new Extension[]{testExtension}).initialize();){
            TestExtension containerExtension = (TestExtension)seContainer.select(TestExtension.class, new Annotation[0]).get();
            Assert.assertTrue((boolean)containerExtension.getBeforeBeanDiscoveryNotified().get());
            Assert.assertTrue((boolean)containerExtension.getAfterTypeDiscoveryNotified().get());
            Assert.assertTrue((boolean)containerExtension.getAfterBeanDiscoveryNotified().get());
            Assert.assertTrue((boolean)containerExtension.getAfterDeploymentValidationNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessAnnotatedTypeNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessInjectionTargetNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessBeanAttributesNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessBeanNotified().get());
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="de"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAddExtensionAsClass() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{Foo.class}).addExtensions(new Class[]{TestExtension.class}).initialize();){
            TestExtension containerExtension = (TestExtension)seContainer.select(TestExtension.class, new Annotation[0]).get();
            Assert.assertTrue((boolean)containerExtension.getBeforeBeanDiscoveryNotified().get());
            Assert.assertTrue((boolean)containerExtension.getAfterTypeDiscoveryNotified().get());
            Assert.assertTrue((boolean)containerExtension.getAfterBeanDiscoveryNotified().get());
            Assert.assertTrue((boolean)containerExtension.getAfterDeploymentValidationNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessAnnotatedTypeNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessInjectionTargetNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessBeanAttributesNotified().get());
            Assert.assertTrue((boolean)containerExtension.getProcessBeanNotified().get());
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="df"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAddInterceptor() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{Bar.class, BarInterceptor1.class, BarInterceptor2.class}).enableInterceptors(new Class[]{BarInterceptor1.class, BarInterceptor2.class}).initialize();){
            Bar bar = (Bar)seContainer.select(Bar.class, new Annotation[0]).get();
            int result = bar.ping();
            Assert.assertTrue((boolean)BarInterceptor1.notified);
            Assert.assertTrue((boolean)BarInterceptor2.notified);
            Assert.assertEquals((int)result, (int)3);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="se_bootstrap", id="dg"), @SpecAssertion(section="se_container_initializer", id="b")})
    public void testAddDecorator() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.disableDiscovery().addBeanClasses(new Class[]{Corge.class, CorgeImpl.class, CorgeDecorator.class}).enableDecorators(new Class[]{CorgeDecorator.class}).initialize();){
            Corge corge = (Corge)seContainer.select(Corge.class, new Annotation[0]).get();
            int result = corge.ping();
            Assert.assertTrue((boolean)CorgeDecorator.notified);
            Assert.assertEquals((int)result, (int)2);
        }
    }

    @Test
    @SpecAssertion(section="se_container", id="d")
    public void testSeContainerLookup() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer seContainer = seContainerInitializer.initialize();){
            Instance garplyInstance = seContainer.select(Garply.class, new Annotation[0]);
            Assert.assertTrue((boolean)garplyInstance.isResolvable());
            Assert.assertEquals((int)((Garply)garplyInstance.get()).getNumber(), (int)0);
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="se_container", id="cc")
    public void seContainerThrowsISEWhenAccessingBmAtShutdownContainer() {
        SeContainer seContainer = this.initializeAndShutdownContainer();
        BeanManager bm = seContainer.getBeanManager();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="se_container", id="e")
    public void instanceSelectClassThrowsISEWhenAccessedAfterShutdown() {
        SeContainer seContainer = this.initializeAndShutdownContainer();
        seContainer.select(Corge.class, new Annotation[0]);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="se_container", id="e")
    public void instanceSelectAnnotationThrowsISEWhenAccessedAfterShutdown() {
        SeContainer seContainer = this.initializeAndShutdownContainer();
        seContainer.select(new Annotation[]{InjectLiteral.INSTANCE});
    }

    private SeContainer initializeAndShutdownContainer() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        SeContainer seContainer = seContainerInitializer.initialize();
        seContainer.close();
        Assert.assertFalse((boolean)seContainer.isRunning());
        return seContainer;
    }
}

