/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.builtin.http.servletcontext;

import jakarta.enterprise.inject.spi.Decorator;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.builtin.http.servletcontext.ServletContextDecorator1;
import org.jboss.cdi.tck.tests.decorators.builtin.http.servletcontext.ServletContextDecorator2;
import org.jboss.cdi.tck.tests.full.decorators.AbstractDecoratorTest;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0")
public class BuiltinServletContextDecoratorTest
extends AbstractDecoratorTest {
    @Inject
    ServletContext servletContext;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinServletContextDecoratorTest.class)).withClass(AbstractDecoratorTest.class)).withBeansXml(new BeansXml().decorators(new Class[]{ServletContextDecorator1.class, ServletContextDecorator2.class}))).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean_ee", id="ack")})
    public void testDecoratorIsResolved() {
        List decorators = this.getCurrentManager().resolveDecorators(Collections.singleton(ServletContext.class), new Annotation[0]);
        Assert.assertEquals((int)2, (int)decorators.size());
        for (Decorator decorator : decorators) {
            Assert.assertEquals((Set)decorator.getDecoratedTypes(), Collections.singleton(ServletContext.class));
            Assert.assertEquals((Object)decorator.getDelegateType(), ServletContext.class);
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean_ee", id="ack")})
    public void testDecoratorIsInvoked() {
        Assert.assertEquals((String)this.servletContext.getContextPath(), (String)"whee");
        Assert.assertEquals((int)this.servletContext.getMajorVersion(), (int)20);
        Assert.assertNotNull((Object)this.servletContext.getServerInfo());
    }
}

