/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.EJBJNDIProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Full;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ClassloaderServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextEJBProvider;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionFromEJBServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionWebBean;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.JNDIServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.JSPSecurityServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.SecurityServlet;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Full
@RunAsClient
public class ContextPropagationFullTests
extends TestClient {
    @TestName
    private String testname;
    @ArquillianResource(value=JNDIServlet.class)
    private URL jndiURL;
    @ArquillianResource(value=JSPSecurityServlet.class)
    private URL jspURL;
    @ArquillianResource(value=ClassloaderServlet.class)
    private URL classloaderURL;
    @ArquillianResource(value=SecurityServlet.class)
    private URL securityURL;
    @ArquillianResource(value=ContextServiceDefinitionServlet.class)
    private URL contextURL;
    @ArquillianResource(value=ContextServiceDefinitionFromEJBServlet.class)
    private URL ejbContextURL;

    @Deployment(name="ContextPropagationTests")
    public static EnterpriseArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ContextPropagationTests_web.war")).addPackages(true, new String[]{Common.PACKAGE.CONTEXT.getPackageName(), Common.PACKAGE.CONTEXT_PROVIDERS.getPackageName()})).addClasses(new Class[]{ContextServiceDefinitionServlet.class, ClassloaderServlet.class, JNDIServlet.class, SecurityServlet.class, JSPSecurityServlet.class, ContextServiceDefinitionFromEJBServlet.class})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()})).addAsWebInfResource(ContextPropagationFullTests.class.getPackage(), "web.xml", "web.xml")).addAsWebResource(ContextPropagationFullTests.class.getPackage(), "jspTests.jsp", "jspTests.jsp");
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ContextPropagationTests_ejb.jar")).addPackages(true, new Package[]{ContextPropagationFullTests.class.getPackage()})).deleteClasses(new Class[]{ContextServiceDefinitionServlet.class, ClassloaderServlet.class, JNDIServlet.class, SecurityServlet.class, JSPSecurityServlet.class, ContextServiceDefinitionFromEJBServlet.class, ContextServiceDefinitionWebBean.class})).addAsServiceProvider(EJBJNDIProvider.class, new Class[]{ContextEJBProvider.FullProvider.class})).addAsManifestResource(ContextPropagationFullTests.class.getPackage(), "ejb-jar.xml", "ejb-jar.xml");
        EnterpriseArchive ear = (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"ContextPropagationTests.ear")).addAsModules(new Archive[]{war, jar});
        return ear;
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/pull/206", version="3.0.0", reason="HttpServletRequest.getUserPrincipal behavior is unclear when accessed from another thread or the current user is changed")
    @Assertion(id="GIT:154", strategy="From a JSP, use a ContextService that is defined by a ContextServiceDefinition elsewhere within the application to clear Security context from the thread of execution while the task is running.")
    public void testSecurityClearedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/pull/206", version="3.0.0", reason="HttpServletRequest.getUserPrincipal behavior is unclear when accessed from another thread or the current user is changed")
    @Assertion(id="GIT:154", strategy="From a JSP, use a ContextService that is defined by a ContextServiceDefinition elsewhere within the application to leave Security context unchanged on the executing thread.")
    public void testSecurityUnchangedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="From a JSP, use a ManagedExecutorService that is defined by a ManagedExecutorDefinition elsewhere within the application to propagate Security context.")
    public void testSecurityPropagatedContext() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jspURL).withPaths("jspTests.jsp").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="SPEC:85 SPEC:76 SPEC:76.1 SPEC:76.2 SPEC:76.3 SPEC:77 SPEC:84 SPEC:2 SPEC:4.1", strategy="Create proxy in servlet and pass it into ejb container, then verify JNDI Context.")
    public void testJNDIContextAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jndiURL).withPaths("JNDIServlet").withTestName(this.testname);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testname + "failed to get correct result.", "JNDIContextWeb", resp);
    }

    @Assertion(id="SPEC:85 SPEC:76 SPEC:76.1 SPEC:76.2 SPEC:76.3 SPEC:77 SPEC:84 SPEC:3 SPEC:3.1 SPEC:3.2 SPEC:3.3 SPEC:3.4 SPEC:4", strategy="Create proxy in servlet and pass it into ejb container, then verify JNDI Context.")
    public void testJNDIContextAndCreateProxyInEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.jndiURL).withPaths("JNDIServlet").withTestName(this.testname);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testname + "failed to get correct result.", "JNDIContextEJB", resp);
    }

    @Assertion(id="SPEC:85 SPEC:76 SPEC:76.1 SPEC:76.2 SPEC:76.3 SPEC:77 SPEC:84 SPEC:4.2 SPEC:4.4;", strategy="Create proxy in servlet and pass it into ejb container, then verify classloader.")
    public void testClassloaderAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.securityURL).withPaths("ClassloaderServlet").withTestName(this.testname);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testname + "failed to get correct result.", "ConcurrentResultOkay", resp);
    }

    @Assertion(id="SPEC:85 SPEC:76 SPEC:76.1 SPEC:76.2 SPEC:76.3 SPEC:77 SPEC:84 SPEC:4.3 SPEC:4.4 SPEC:4.4", strategy="Create proxy in servlet and pass it into ejb container, then verify permission.")
    public void testSecurityAndCreateProxyInServlet() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.classloaderURL).withPaths("SecurityServlet").withTestName(this.testname);
        String resp = this.runTestWithResponse(requestURL, null);
        this.assertStringInResponse(this.testname + "failed to get correct result.", "ConcurrentResultOkay", resp);
    }

    @Assertion(id="GIT:154", strategy="ContextServiceDefinition with all attributes configured propagates/clears/ignores context types as configured")
    public void testContextServiceDefinitionAllAttributes() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="ContextServiceDefinition with all attributes configured propagates/clears/ignores context types as configured")
    public void testContextServiceDefinitionFromEJBAllAttributes() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="A ContextServiceDefinition with minimal attributes configured clears transaction context and propagates other types.")
    public void testContextServiceDefinitionDefaults() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="A ContextServiceDefinition defined in an EJB with minimal attributes configured clears transaction context and propagates other types.")
    public void testContextServiceDefinitionFromEJBDefaults() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="A ContextServiceDefinition can specify a third-party context type to be propagated/cleared/ignored")
    public void testContextServiceDefinitionWithThirdPartyContext() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="ContextService contextualizes a java.util.function.Consumer, which can be supplied as a dependent stage action to an unmanaged CompletableFuture. The dependent stage action runs with the thread context of the thread that contextualizes the Consumer, per the configuration of the ContextServiceDefinition.")
    public void testContextualConsumer() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/253", version="3.0.1", reason="Assertions on results[0] and results[1] are both invalid because treating those two UNCHANGED context types as though they were CLEARED.")
    @Assertion(id="GIT:154", strategy="A ContextService contextualizes a Function, which can be supplied as a dependent stage action to an unmanaged CompletableFuture. The dependent stage action runs with the thread context of the thread that contextualizes the Function, per the configuration of the ContextServiceDefinition.")
    public void testContextualFunction() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="A ContextService contextualizes a Supplier, which can be supplied as a dependent stage action to an unmanaged CompletableFuture. The dependent stage action runs with the thread context of the thread that contextualizes the Supplier, per the configuration of the ContextServiceDefinition.")
    public void testContextualSupplier() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
        requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ContextServiceDefinitionFromEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="ContextService can create a contextualized copy of an unmanaged CompletableFuture.")
    public void testCopyWithContextCapture() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:368", strategy="A ContextService contextualizes a Flow.Subscriber, which is subscribed to an unmanaged Flow.Producer.The Flow.Subscriber methods are run with the thread context of the thread which contextualizes the Flow.Subscriber per the configuration of the ContextServiceDefinition.")
    public void testContextualFlowSubscriber() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:368", strategy="A ContextService contextualizes a Flow.Processor, which is subscribed to an unmanaged Flow.Producer.The Flow.Processor methods are run with the thread context of the thread which contextualizes the Flow.Processor per the configuration of the ContextServiceDefinition.")
    public void testContextualFlowProcessor() throws Throwable {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.contextURL).withPaths("ContextServiceDefinitionServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }
}

