/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class ExtendedResult
extends LDAPResult {
    private static final byte TYPE_EXTENDED_RESPONSE_OID = -118;
    private static final byte TYPE_EXTENDED_RESPONSE_VALUE = -117;
    private static final long serialVersionUID = -6885923482396647963L;
    private final ASN1OctetString value;
    private final String oid;

    public ExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, String oid, ASN1OctetString value, Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, responseControls);
        this.oid = oid;
        this.value = value;
    }

    public ExtendedResult(LDAPResult result) {
        super(result);
        this.oid = null;
        this.value = null;
    }

    public ExtendedResult(LDAPException exception) {
        this(exception.toLDAPResult());
    }

    protected ExtendedResult(ExtendedResult extendedResult) {
        this(extendedResult.getMessageID(), extendedResult.getResultCode(), extendedResult.getDiagnosticMessage(), extendedResult.getMatchedDN(), extendedResult.getReferralURLs(), extendedResult.getOID(), extendedResult.getValue(), extendedResult.getResponseControls());
    }

    static ExtendedResult readExtendedResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        try {
            String diagnosticMessage;
            ASN1StreamReaderSequence protocolOpSequence = reader.beginSequence();
            ResultCode resultCode = ResultCode.valueOf(reader.readEnumerated());
            String matchedDN = reader.readString();
            if (matchedDN.length() == 0) {
                matchedDN = null;
            }
            if ((diagnosticMessage = reader.readString()).length() == 0) {
                diagnosticMessage = null;
            }
            String[] referralURLs = null;
            String oid = null;
            ASN1OctetString value = null;
            block8: while (protocolOpSequence.hasMoreElements()) {
                byte type = (byte)reader.peek();
                switch (type) {
                    case -93: {
                        ArrayList<String> refList = new ArrayList<String>(1);
                        ASN1StreamReaderSequence refSequence = reader.beginSequence();
                        while (refSequence.hasMoreElements()) {
                            refList.add(reader.readString());
                        }
                        referralURLs = new String[refList.size()];
                        refList.toArray(referralURLs);
                        continue block8;
                    }
                    case -118: {
                        oid = reader.readString();
                        continue block8;
                    }
                    case -117: {
                        value = new ASN1OctetString(type, reader.readBytes());
                        continue block8;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_EXTENDED_RESULT_INVALID_ELEMENT.get(StaticUtils.toHex(type)));
            }
            Control[] controls = NO_CONTROLS;
            if (messageSequence.hasMoreElements()) {
                ArrayList<Control> controlList = new ArrayList<Control>(1);
                ASN1StreamReaderSequence controlSequence = reader.beginSequence();
                while (controlSequence.hasMoreElements()) {
                    controlList.add(Control.readFrom(reader));
                }
                controls = new Control[controlList.size()];
                controlList.toArray(controls);
            }
            return new ExtendedResult(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, oid, value, controls);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_EXTENDED_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public final String getOID() {
        return this.oid;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public String getExtendedResultName() {
        return this.oid;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("ExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(referralURLs[i]);
            }
            buffer.append('}');
        }
        if (this.oid != null) {
            buffer.append(", oid=");
            buffer.append(this.oid);
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

