/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.frame.HeaderFrame;

public class HeadersFrame
extends HeaderFrame {
    public static final int TYPE = 1;
    public static final int END_STREAM = 1;
    public static final int PADDED = 8;
    public static final int PRIORITY = 32;
    private int padLength;
    private int streamDependency;
    private int weight;
    private boolean exclusive;

    public HeadersFrame(int n, int n2, ByteBufferReference[] byteBufferReferenceArray, int n3) {
        super(n, n2, byteBufferReferenceArray);
        if (n3 > 0) {
            this.setPadLength(n3);
        }
    }

    public HeadersFrame(int n, int n2, ByteBufferReference[] byteBufferReferenceArray) {
        super(n, n2, byteBufferReferenceArray);
    }

    public HeadersFrame(int n, int n2, ByteBufferReference byteBufferReference) {
        this(n, n2, new ByteBufferReference[]{byteBufferReference});
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    int length() {
        return this.headerLength + ((this.flags & 8) != 0 ? 1 + this.padLength : 0) + ((this.flags & 0x20) != 0 ? 5 : 0);
    }

    @Override
    public String flagAsString(int n) {
        switch (n) {
            case 1: {
                return "END_STREAM";
            }
            case 8: {
                return "PADDED";
            }
            case 32: {
                return "PRIORITY";
            }
        }
        return super.flagAsString(n);
    }

    public void setPadLength(int n) {
        this.padLength = n;
        this.flags |= 8;
    }

    int getPadLength() {
        return this.padLength;
    }

    public void setPriority(int n, boolean bl, int n2) {
        this.streamDependency = n;
        this.exclusive = bl;
        this.weight = n2;
        this.flags |= 0x20;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean getExclusive() {
        return this.exclusive;
    }
}

