/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.generics;

import ee.jakarta.tck.json.bind.defaultmapping.generics.model.CollectionContainer;
import ee.jakarta.tck.json.bind.defaultmapping.generics.model.GenericContainer;
import ee.jakarta.tck.json.bind.defaultmapping.generics.model.MultipleBoundsContainer;
import ee.jakarta.tck.json.bind.defaultmapping.generics.model.NumberContainer;
import ee.jakarta.tck.json.bind.defaultmapping.generics.model.StringContainer;
import ee.jakarta.tck.json.bind.defaultmapping.generics.model.WildcardContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class GenericsMappingTest {
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testClassInformationOnRuntime() {
        String jsonString = this.jsonb.toJson((Object)new GenericContainer<String>(){
            {
                this.setInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal generic object with String attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        Type runtimeType = new GenericContainer<String>(){}.getClass().getGenericSuperclass();
        GenericContainer unmarshalledObject = (GenericContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", runtimeType);
        MatcherAssert.assertThat((String)"Failed to unmarshal generic object with String attribute value.", (Object)((String)unmarshalledObject.getInstance()), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testClassFileAvailable() {
        String jsonString = this.jsonb.toJson((Object)new GenericContainer<String>(){
            {
                this.setInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal generic object with String attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        GenericContainer unmarshalledObject = (GenericContainer)this.jsonb.fromJson("{ \"instance\" : \"Test String\" }", StringContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal generic object with String attribute value.", (Object)((String)unmarshalledObject.getInstance()), (Matcher)Matchers.is((Object)"Test String"));
    }

    @Test
    public void testRawTypeInformation() {
        final List<String> list = Arrays.asList("Test 1", "Test 2");
        String jsonString = this.jsonb.toJson((Object)new CollectionContainer(){
            {
                this.setInstance(list);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with raw List attribute.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}"));
        CollectionContainer unmarshalledObject = (CollectionContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", CollectionContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with raw List type attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is(list));
    }

    @Test
    public void testNoTypeInformation() {
        String jsonString = this.jsonb.toJson((Object)new GenericContainer<String>(){
            {
                this.setInstance("Test String");
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal generic object with String attribute value.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\"Test String\"\\s*\\}"));
        GenericContainer unmarshalledObject = (GenericContainer)this.jsonb.fromJson("{ \"instance\" : {\"value\":\"Test String\" } }", GenericContainer.class);
        String validationMessage = "Failed to unmarshal generic object without type information with String attribute value.";
        Object evaluatedInstance = unmarshalledObject.getInstance();
        MatcherAssert.assertThat((String)validationMessage, evaluatedInstance, (Matcher)Matchers.instanceOf(Map.class));
        Map map = (Map)evaluatedInstance;
        MatcherAssert.assertThat((String)validationMessage, (Object)map.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)validationMessage, (Object)map, (Matcher)Matchers.hasEntry((Object)"value", (Object)"Test String"));
    }

    @Test
    public void testBoundedTypeInformation() {
        String jsonString = this.jsonb.toJson((Object)new NumberContainer<Integer>(){
            {
                this.setInstance(Integer.MAX_VALUE);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with bounded Number attribute.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*2147483647\\s*\\}"));
        Type runtimeType = new NumberContainer<Integer>(){}.getClass().getGenericSuperclass();
        NumberContainer unmarshalledObject = (NumberContainer)this.jsonb.fromJson("{ \"instance\" : 2147483647 }", runtimeType);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with bounded Number attribute.", (Object)((Integer)unmarshalledObject.getInstance()), (Matcher)Matchers.is((Object)Integer.MAX_VALUE));
    }

    @Test
    public void testMultipleBoundsTypeInformation() {
        LinkedList<String> list = new LinkedList<String>(Arrays.asList("Test 1", "Test 2"));
        MultipleBoundsContainer container = new MultipleBoundsContainer();
        container.setInstance(new ArrayList());
        container.getInstance().add(list);
        Type type = new MultipleBoundsContainer<LinkedList<String>>(){}.getClass().getGenericSuperclass();
        String jsonString = this.jsonb.toJson(container, type);
        MatcherAssert.assertThat((String)"Failed to marshal object with multiple bounded attribute.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\\[\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\]\\s*\\}"));
        String toDeserialize = "{ \"instance\" : [[ \"Test 1\", \"Test 2\" ]] }";
        MultipleBoundsContainer unmarshalledObject = (MultipleBoundsContainer)this.jsonb.fromJson(toDeserialize, type);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with multiple bounded attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)container.getInstance()));
    }

    @Test
    public void testWildcardTypeInformation() {
        final List<String> list = Arrays.asList("Test 1", "Test 2");
        String jsonString = this.jsonb.toJson((Object)new WildcardContainer(){
            {
                this.setInstance(list);
            }
        });
        MatcherAssert.assertThat((String)"Failed to marshal object with unbound collection attribute.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*\\:\\s*\\[\\s*\"Test 1\"\\s*,\\s*\"Test 2\"\\s*\\]\\s*\\}"));
        WildcardContainer unmarshalledObject = (WildcardContainer)this.jsonb.fromJson("{ \"instance\" : [ \"Test 1\", \"Test 2\" ] }", WildcardContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal object with unbound collection attribute.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is(list));
    }
}

