/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.MethodOverridingChecker;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassHierarchyImpl
implements ClassHierarchy {
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private ClassDescriptionLoader loader;
    private int trackMode;
    private Filter defaultFilter = new DefaultIsAccessibleFilter();
    private Pattern anonimouse = Pattern.compile("\\$\\d+$");
    private static Pattern simpleParamUsage = Pattern.compile("<[^<>]+?>");
    private Map<String, List<String>> directSubClasses = new HashMap<String, List<String>>();
    private HashMap<String, ClassInfo> processedClasses = new HashMap();
    private BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);

    public ClassHierarchyImpl(ClassDescriptionLoader loader) {
        this.loader = loader;
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        this.trackMode = bo.isSet(Option.ALL_PUBLIC) ? 2 : 0;
    }

    public ClassHierarchyImpl(ClassDescriptionLoader loader, int trackMode) {
        this.loader = loader;
        this.trackMode = trackMode;
    }

    @Override
    public String getSuperClass(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.superClass;
    }

    @Override
    public List<String> getSuperClasses(String fqClassName) throws ClassNotFoundException {
        ArrayList<String> superclasses = new ArrayList<String>();
        this.findSuperclasses(fqClassName, superclasses);
        return superclasses;
    }

    @Override
    public String[] getSuperInterfaces(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.superInterfaces;
    }

    @Override
    public Set<String> getAllImplementedInterfaces(String fqClassName) throws ClassNotFoundException {
        HashSet<String> intfs = new HashSet<String>();
        this.findAllImplementedInterfaces(fqClassName, intfs);
        return intfs;
    }

    private void findSuperclasses(String fqname, List<String> supers) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqname);
        String supr = info.superClass;
        if (supr != null) {
            supers.add(supr);
            this.findSuperclasses(supr, supers);
        }
    }

    private void findAllImplementedInterfaces(String fqname, Set<String> implementedInterfaces) throws ClassNotFoundException {
        ArrayList<String> superClasses = new ArrayList<String>();
        ClassInfo info = this.getClassInfo(fqname);
        String[] intfs = info.superInterfaces;
        for (int j = 0; j < intfs.length; ++j) {
            implementedInterfaces.add(intfs[j]);
            superClasses.add(intfs[j]);
        }
        this.findSuperclasses(fqname, superClasses);
        for (int i = 0; i < superClasses.size(); ++i) {
            this.findSuperInterfaces((String)superClasses.get(i), implementedInterfaces);
        }
    }

    private void findSuperInterfaces(String fqname, Set<String> supers) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqname);
        String[] intf = info.superInterfaces;
        for (int i = 0; i < intf.length; ++i) {
            supers.add(intf[i]);
            this.findSuperInterfaces(intf[i], supers);
        }
    }

    @Override
    public String[] getDirectSubclasses(String fqClassName) {
        String[] result = EMPTY_STRING_ARRAY;
        List<String> subClasses = this.directSubClasses.get(fqClassName);
        if (subClasses != null) {
            result = subClasses.toArray(EMPTY_STRING_ARRAY);
        }
        return result;
    }

    @Override
    public String[] getAllSubclasses(String fqClassName) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public String[] getNestedClasses(String fqClassName) {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public boolean isSubclass(String subClassName, String superClassName) throws ClassNotFoundException {
        assert (subClassName != null && superClassName != null);
        if (subClassName.charAt(0) == '{' || superClassName.charAt(0) == '{') {
            return false;
        }
        String name = subClassName;
        do {
            try {
                ClassInfo info = this.getClassInfo(name);
                if (superClassName.equals(info.superClass)) {
                    return true;
                }
                name = info.superClass;
            }
            catch (ClassNotFoundException cnfe) {
                if (this.bo.isSet(Option.DEBUG)) {
                    SwissKnife.reportThrowable(cnfe);
                }
                return false;
            }
        } while (name != null);
        return false;
    }

    @Override
    public ClassDescription load(String name) throws ClassNotFoundException {
        return this.load(name, false);
    }

    @Override
    public boolean isMethodOverriden(MethodDescr md) throws ClassNotFoundException {
        Erasurator erasurator = new Erasurator();
        MethodOverridingChecker moc = new MethodOverridingChecker(erasurator);
        for (String sup : this.getSuperClasses(md.getDeclaringClassName())) {
            ClassDescription sc = this.load(sup);
            erasurator.erasure(sc);
            moc.addMethods(sc.getDeclaredMethods());
        }
        return moc.getOverridingMethod(md, false) != null;
    }

    @Override
    public boolean isMethodImplements(MethodDescr md) throws ClassNotFoundException {
        Erasurator erasurator = new Erasurator();
        MethodOverridingChecker moc = new MethodOverridingChecker(erasurator);
        String name = md.getName();
        for (String inf : this.getAllImplementedInterfaces(md.getDeclaringClassName())) {
            ClassDescription sc = this.load(inf);
            erasurator.erasure(sc);
            moc.addMethods(sc.getDeclaredMethods(), name);
        }
        if (moc.getOverridingMethod(md, false) != null) {
            return true;
        }
        return this.isAnonimouse(md.getDeclaringClassName());
    }

    private boolean isAnonimouse(String clName) {
        boolean ret = this.anonimouse.matcher(clName).find();
        return ret;
    }

    private ClassDescription load(String name, boolean no_cache) throws ClassNotFoundException {
        ClassDescription c;
        while (name.indexOf(60) != -1 && name.indexOf(62) != -1) {
            Matcher m = simpleParamUsage.matcher(name);
            name = m.replaceAll("");
        }
        try {
            c = this.loader.load(name);
        }
        catch (ClassNotFoundException ce) {
            assert (AppContext.getContext() != null);
            Classpath cp = AppContext.getContext().getInputClasspath();
            if (cp != null) {
                c = cp.findClassDescription(name);
            }
            throw new ClassNotFoundException(name);
        }
        Transformer t = PluginAPI.ON_CLASS_LOAD.getTransformer();
        if (t != null) {
            t.transform(c);
        }
        if (!no_cache) {
            this.getClassInfo(name);
        }
        c.setHierarchy(this);
        return c;
    }

    @Override
    public boolean isAccessible(ClassDescription c) {
        return this.isAccessible(c, false);
    }

    @Override
    public boolean isDocumentedAnnotation(String fqname) throws ClassNotFoundException {
        ClassInfo info = this.processedClasses.get(fqname);
        if (info != null) {
            return info.isDocumentedAnnotation;
        }
        ClassDescription c = this.load(fqname);
        return c.isDocumentedAnnotation();
    }

    @Override
    public boolean isContainerAnnotation(String fqname) throws ClassNotFoundException {
        ClassDescription c = this.load(fqname);
        try {
            if (c.hasModifier(Modifier.ANNOTATION)) {
                MethodDescr[] mds = c.getDeclaredMethods();
                String aType = null;
                for (int i = 0; i < mds.length; ++i) {
                    MethodDescr md = mds[i];
                    if (md.getName().equals("value") && "".equals(c.getArgs())) {
                        aType = md.getType();
                        continue;
                    }
                    if (md.hasModifier(Modifier.HASDEFAULT)) continue;
                    return false;
                }
                if (aType == null || !aType.endsWith("[]")) {
                    return false;
                }
                ClassDescription a = this.load(aType = aType.substring(0, aType.length() - 2));
                if (!a.hasModifier(Modifier.ANNOTATION)) {
                    return false;
                }
                AnnotationItem[] alist = a.getAnnoList();
                for (int i = 0; i < alist.length; ++i) {
                    if (!alist[i].getName().equals("java.lang.annotation.Repeatable")) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isAccessible(String fqname) throws ClassNotFoundException {
        if (fqname == null) {
            throw new NullPointerException("Parameter fqname can't be null!");
        }
        ClassInfo info = this.processedClasses.get(fqname);
        if (info != null) {
            return info.accessable;
        }
        ClassDescription c = this.load(fqname);
        return this.isAccessible(c, false);
    }

    private boolean isAccessible(ClassDescription c, boolean no_cache) {
        ClassInfo info;
        if (!no_cache && (info = this.processedClasses.get(c.getQualifiedName())) != null) {
            return info.accessable;
        }
        if (c.isAnonymousClass()) {
            return false;
        }
        Filter f = PluginAPI.IS_CLASS_ACCESSIBLE.getFilter();
        if (f == null) {
            f = this.defaultFilter;
        }
        return f.accept(c);
    }

    @Override
    public boolean isClassVisibleOutside(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.isVisibleOutside;
    }

    @Override
    public boolean isClassVisibleOutside(ClassDescription cls) throws ClassNotFoundException {
        boolean visible;
        boolean bl = visible = cls.hasModifier(Modifier.PUBLIC) || cls.hasModifier(Modifier.PROTECTED);
        if (visible && !cls.isTopClass()) {
            visible = this.isClassVisibleOutside(cls.getDeclaringClassName());
        }
        return visible;
    }

    @Override
    public boolean isInterface(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return Modifier.hasModifier(info.modifiers, Modifier.INTERFACE);
    }

    @Override
    public boolean isAnnotation(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return Modifier.hasModifier(info.modifiers, Modifier.ANNOTATION);
    }

    @Override
    public int getClassModifiers(String fqClassName) throws ClassNotFoundException {
        ClassInfo info = this.getClassInfo(fqClassName);
        return info.modifiers;
    }

    private ClassInfo getClassInfo(String fqname) throws ClassNotFoundException {
        ClassInfo info = this.processedClasses.get(fqname);
        if (info == null) {
            ClassDescription c = this.load(fqname, true);
            info = new ClassInfo(c, this.isAccessible(c, true), this.isClassVisibleOutside(c));
            if (info.superClass != null) {
                this.addSubClass(info.superClass, fqname);
            }
            if (info.superInterfaces != null && info.superInterfaces.length > 0) {
                for (int i = 0; i < info.superInterfaces.length; ++i) {
                    this.addSubClass(info.superInterfaces[i], fqname);
                }
            }
            this.processedClasses.put(fqname, info);
        }
        return info;
    }

    private void addSubClass(String superClass, String subClass) {
        List<String> subClasses = this.directSubClasses.get(superClass);
        if (subClasses == null) {
            subClasses = new ArrayList<String>(3);
            this.directSubClasses.put(superClass, subClasses);
        }
        subClasses.add(subClass);
    }

    @Override
    public int getTrackMode() {
        return this.trackMode;
    }

    class DefaultIsAccessibleFilter
    implements Filter {
        DefaultIsAccessibleFilter() {
        }

        private boolean isAccessible(ClassDescription c) {
            boolean result;
            block4: {
                if (c.isModuleOrPackaheInfo()) {
                    return true;
                }
                if (ClassHierarchyImpl.this.trackMode == 2) {
                    return c.isPublic() || c.isProtected();
                }
                result = false;
                try {
                    result = c.getClassHierarchy().isClassVisibleOutside(c);
                }
                catch (ClassNotFoundException e) {
                    if (!ClassHierarchyImpl.this.bo.isSet(Option.DEBUG)) break block4;
                    SwissKnife.reportThrowable(e);
                }
            }
            return result;
        }

        @Override
        public boolean accept(ClassDescription cls) {
            return this.isAccessible(cls);
        }
    }

    private static class ClassInfo {
        private static final String[] EMPTY_INTERFACES = new String[0];
        String superClass = null;
        String[] superInterfaces = EMPTY_INTERFACES;
        boolean accessable = false;
        boolean isDocumentedAnnotation = false;
        int modifiers = 0;
        boolean isVisibleOutside;

        public ClassInfo(ClassDescription c, boolean accessable, boolean visible) {
            SuperInterface[] intfs;
            int len;
            this.modifiers = c.getModifiers();
            SuperClass sc = c.getSuperClass();
            if (sc != null) {
                this.superClass = sc.getQualifiedName();
            }
            if ((len = (intfs = c.getInterfaces()).length) > 0) {
                this.superInterfaces = new String[len];
                for (int i = 0; i < len; ++i) {
                    this.superInterfaces[i] = intfs[i].getQualifiedName();
                }
            }
            this.accessable = accessable;
            this.isVisibleOutside = visible;
            this.isDocumentedAnnotation = c.isDocumentedAnnotation();
        }
    }
}

