/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.security.csrf.exception;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mvcspec.tck.tests.security.csrf.exception.CsrfCustomExceptionMapper;
import org.mvcspec.tck.tests.security.csrf.exception.CsrfCustomMapperController;
import org.mvcspec.tck.util.Archives;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class CsrfCustomMapperTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(CsrfCustomMapperController.class).addClass(CsrfCustomExceptionMapper.class).addView("csrf/exception/form.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="cross-site-request-forgery", id="csrf-exception"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-custom-mapper")})
    public void customExceptionMapper() throws IOException {
        HtmlPage formPage = (HtmlPage)this.webClient.getPage(this.baseUrl.toString() + "mvc/csrf/exception/form");
        Assert.assertThat((Object)formPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        DomElement nameInputElement = formPage.getElementById("input");
        Assert.assertNotNull((String)"Name input element not found", (Object)nameInputElement);
        nameInputElement.setAttribute("value", "Alice");
        DomElement submitButton = formPage.getElementById("submit");
        Assert.assertNotNull((String)"Submit button not found", (Object)submitButton);
        Page resultPage = submitButton.click();
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)499));
    }
}

