/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.delete;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Fruit;
import ee.jakarta.tck.nosql.factories.FruitListSupplier;
import jakarta.nosql.Template;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="Delete execution with @Convert annotated fields in the entity")
public class DeleteFieldConvertTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with converted quantity equals condition")
    void shouldInsertIterableAndDeleteWithQuantityEqualsCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            Long targetQuantity = entities.get(0).getQuantity();
            this.template.delete(Fruit.class).where("quantity").eq((Object)targetQuantity).execute();
            List result = this.template.select(Fruit.class).where("quantity").eq((Object)targetQuantity).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with quantity greater-than condition")
    void shouldInsertIterableAndDeleteWithQuantityGreaterThanCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            long targetQuantity = entities.get(0).getQuantity() - 1L;
            this.template.delete(Fruit.class).where("quantity").gt((Object)targetQuantity).execute();
            List result = this.template.select(Fruit.class).where("quantity").gt((Object)targetQuantity).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with quantity less-than condition")
    void shouldInsertIterableAndDeleteWithQuantityLessThanCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            long targetQuantity = entities.get(0).getQuantity() + 10L;
            this.template.delete(Fruit.class).where("quantity").lt((Object)targetQuantity).execute();
            List result = this.template.select(Fruit.class).where("quantity").lt((Object)targetQuantity).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with quantity between condition")
    void shouldInsertIterableAndDeleteWithQuantityBetweenCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            Long targetQuantity = entities.get(0).getQuantity();
            this.template.delete(Fruit.class).where("quantity").between((Object)(targetQuantity - 5L), (Object)(targetQuantity + 5L)).execute();
            List result = this.template.select(Fruit.class).where("quantity").between((Object)(targetQuantity - 5L), (Object)(targetQuantity + 5L)).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

