/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.ListQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.EditableList;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ListQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    protected static final String INVALID_VALUE = i18n.getString("list.incomplete.txt");
    protected static final String INVALID_VALUE_COLOR = i18n.getString("i18n.error.clr");

    @Override
    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        ListQuestion q = (ListQuestion)qq;
        if (q.isEnd()) {
            return this.createMoreButton(q);
        }
        return this.createList(q, listener);
    }

    @Override
    public String getInvalidValueMessage(Question qq) {
        ListQuestion q = (ListQuestion)qq;
        return i18n.getString("list.invalid", new Integer(q.getIncompleteBodyCount()));
    }

    protected JComponent createMoreButton(ListQuestion q) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setName("more");
        panel.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 14;
        JButton btn = new JButton(i18n.getString("list.more.btn"));
        btn.setName("list.more.btn");
        btn.setMnemonic(i18n.getString("list.more.mne").charAt(0));
        btn.setToolTipText(i18n.getString("list.more.tip"));
        btn.addActionListener(this.createMoreBtnListener(q));
        panel.add((Component)btn, c);
        return panel;
    }

    protected ActionListener createMoreBtnListener(final ListQuestion q) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListQuestion listStart = q.getOther();
                try {
                    ListQuestionRenderer.getRootInterview(q).setCurrentQuestion(listStart);
                }
                catch (Interview.Fault fault) {
                    // empty catch block
                }
            }
        };
    }

    protected JComponent createList(ListQuestion q, ActionListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setName("list");
        panel.setFocusable(false);
        JLabel label = new JLabel(i18n.getString("list.lbl"));
        label.setName("list.lbl");
        label.setDisplayedMnemonic(i18n.getString("list.mne").charAt(0));
        label.setToolTipText(i18n.getString("list.tip"));
        panel.add((Component)label, "North");
        BodyList list = new BodyList(q);
        ListQuestion.Body seln = q.getSelectedBody();
        if (seln != null) {
            list.setSelectedItem(seln);
        }
        label.setLabelFor(list);
        panel.add((Component)list, "Center");
        return panel;
    }

    protected static Interview getRootInterview(Question q) {
        Interview i = q.getInterview();
        while (i.getParent() != null) {
            i = i.getParent();
        }
        return i;
    }

    protected class BodyList
    extends EditableList {
        private ListQuestion question;

        BodyList(ListQuestion q) {
            super("list", q.getBodies());
            this.question = q;
        }

        @Override
        protected Object getDisplayValue(Object item) {
            if (item instanceof ListQuestion.Body) {
                ListQuestion.Body b = (ListQuestion.Body)item;
                String s = b.getSummary();
                if (s == null) {
                    s = b.getDefaultSummary();
                }
                if (b.isBodyFinishable()) {
                    return s;
                }
                return "<html><b><font color=\"" + INVALID_VALUE_COLOR + "\">*</font></b> " + this.escape(s) + " <font color=\"" + INVALID_VALUE_COLOR + "\">" + this.escape(INVALID_VALUE) + "</font></html>";
            }
            return item;
        }

        @Override
        protected Object getNewItem() {
            int i = this.getSelectedIndex();
            if (i == -1) {
                i = this.getItemCount();
            }
            return this.question.createBody(i);
        }

        @Override
        protected Object getNewItem(Object item) {
            this.question.setValue(this.getSelectedIndex());
            try {
                ListQuestionRenderer.getRootInterview(this.question).next();
            }
            catch (Interview.Fault fault) {
                // empty catch block
            }
            return null;
        }

        @Override
        protected void insertItem() {
            super.insertItem();
            this.itemsChanged();
            try {
                ListQuestionRenderer.getRootInterview(this.question).next();
            }
            catch (Interview.Fault fault) {
                // empty catch block
            }
        }

        @Override
        protected void itemsChanged() {
            this.question.setBodies(this.getBodies(), this.getSelectedIndex());
        }

        @Override
        protected void selectedItemChanged() {
            this.itemsChanged();
            this.question.setValue(this.getSelectedIndex());
        }

        private ListQuestion.Body[] getBodies() {
            ListQuestion.Body[] bodies = (ListQuestion.Body[])this.getItems(ListQuestion.Body.class);
            return bodies;
        }

        private String escape(String text) {
            if (text == null) {
                return "";
            }
            boolean specialChars = false;
            for (int i = 0; i < text.length() && !specialChars; ++i) {
                switch (text.charAt(i)) {
                    case '&': 
                    case '<': 
                    case '>': {
                        specialChars = true;
                    }
                }
            }
            if (specialChars) {
                StringBuffer sb = new StringBuffer();
                block9: for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    switch (c) {
                        case '<': {
                            sb.append("&lt;");
                            continue block9;
                        }
                        case '>': {
                            sb.append("&gt;");
                            continue block9;
                        }
                        case '&': {
                            sb.append("&amp;");
                            continue block9;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            return text;
        }
    }
}

