/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.orderby;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address2;
import ee.jakarta.tck.persistence.core.annotations.orderby.Department;
import ee.jakarta.tck.persistence.core.annotations.orderby.Employee;
import ee.jakarta.tck.persistence.core.annotations.orderby.Insurance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());
    List<Address> addrRef;
    Address addr1 = null;
    Address addr2 = null;
    Address addr3 = null;
    List<Address2> addrRef2;
    Address2 addr11 = null;
    Address2 addr12 = null;
    Address2 addr13 = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "A2", pkgName + "Address", pkgName + "Address2", pkgName + "Customer", pkgName + "Customer2", pkgName + "Department", pkgName + "Employee", pkgName + "Insurance", pkgName + "ZipCode", pkgName + "ZipCode2"};
        return this.createDeploymentJar("jpa_core_annotations_orderby1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void orderByTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin orderByTest1");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Zoe", "Song", "Jie", "Ay"};
        try {
            this.getEntityTransaction().begin();
            Employee empChange = (Employee)this.getEntityManager().find(Employee.class, (Object)65);
            empChange.setFirstName("Ay");
            this.getEntityManager().merge((Object)empChange);
            this.getEntityManager().flush();
            Insurance newIns = (Insurance)this.getEntityManager().find(Insurance.class, (Object)60);
            this.getEntityManager().refresh((Object)newIns);
            List<Employee> insResult = newIns.getEmployees();
            if (insResult.size() != 4) {
                logger.log(System.Logger.Level.TRACE, "orderByTest1:  Did not get expected results.  Expected: 4, got: " + insResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i1 = insResult.iterator();
                logger.log(System.Logger.Level.TRACE, "Check Employee Collection for expected first names");
                while (i1.hasNext()) {
                    Employee e1 = i1.next();
                    resultsList.add(e1.getFirstName());
                    logger.log(System.Logger.Level.TRACE, "orderByTest1: got Employee FirstName:" + e1.getFirstName());
                }
                logger.log(System.Logger.Level.TRACE, "Compare first names received with expected first names ");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void orderByTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin orderByTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Jie", "Song", "Yay", "Zoe"};
        try {
            this.getEntityTransaction().begin();
            Employee emp2Change = (Employee)this.getEntityManager().find(Employee.class, (Object)65);
            emp2Change.setFirstName("Yay");
            this.getEntityManager().merge((Object)emp2Change);
            this.getEntityManager().flush();
            Department newDept = (Department)this.getEntityManager().find(Department.class, (Object)50);
            this.getEntityManager().refresh((Object)newDept);
            List<Employee> deptResult = newDept.getEmployees();
            if (deptResult.size() != 4) {
                logger.log(System.Logger.Level.TRACE, "orderByTest2:  Did not get expected results.  Expected: 4, got: " + deptResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i2 = deptResult.iterator();
                logger.log(System.Logger.Level.TRACE, "Check Employee Collection for expected first names");
                while (i2.hasNext()) {
                    Employee e2 = i2.next();
                    resultsList.add(e2.getFirstName());
                    logger.log(System.Logger.Level.TRACE, "orderByTest2: got Employee FirstName:" + e2.getFirstName());
                }
                logger.log(System.Logger.Level.TRACE, "Compare first names received with expected first names ");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void orderByTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin orderByTest3");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Zoe", "Song", "Penelope", "May", "Jie"};
        try {
            this.getEntityTransaction().begin();
            Employee emp3Change = (Employee)this.getEntityManager().find(Employee.class, (Object)85);
            Insurance ins = (Insurance)this.getEntityManager().find(Insurance.class, (Object)60);
            emp3Change.setInsurance(ins);
            this.getEntityManager().merge((Object)emp3Change);
            ins.getEmployees().add(emp3Change);
            this.getEntityManager().merge((Object)ins);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)ins);
            List<Employee> insResult = ins.getEmployees();
            if (insResult.size() != 5) {
                logger.log(System.Logger.Level.ERROR, "orderByTest3: Expected List Size of 5 got: " + insResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i3 = insResult.iterator();
                logger.log(System.Logger.Level.TRACE, "Check Employee Collection for expected first names");
                while (i3.hasNext()) {
                    Employee e3 = i3.next();
                    resultsList.add(e3.getFirstName());
                    logger.log(System.Logger.Level.TRACE, "orderByTest3: got Employee FirstName:" + e3.getFirstName());
                }
                logger.log(System.Logger.Level.TRACE, "orderByTest3: Expected size received, check ordering . . .");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void orderByTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin orderByTest4");
        boolean pass1 = true;
        boolean pass2 = false;
        ArrayList<String> resultsList = new ArrayList<String>();
        Object[] expectedResult = new String[]{"Jie", "May", "Penelope", "Song", "Zoe"};
        try {
            this.getEntityTransaction().begin();
            Employee emp4Change = (Employee)this.getEntityManager().find(Employee.class, (Object)85);
            Department dept = (Department)this.getEntityManager().find(Department.class, (Object)50);
            emp4Change.setDepartment(dept);
            this.getEntityManager().merge((Object)emp4Change);
            dept.getEmployees().add(emp4Change);
            this.getEntityManager().merge((Object)dept);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)dept);
            List<Employee> deptResult = dept.getEmployees();
            if (deptResult.size() != 5) {
                logger.log(System.Logger.Level.ERROR, "orderByTest4: Expected Collection Size of 5 got: " + deptResult.size());
                pass1 = false;
            } else if (pass1) {
                Iterator<Employee> i4 = deptResult.iterator();
                logger.log(System.Logger.Level.TRACE, "Check Employee Collection for expected first names");
                while (i4.hasNext()) {
                    Employee e4 = i4.next();
                    resultsList.add(e4.getFirstName());
                    logger.log(System.Logger.Level.TRACE, "orderByTest4: got Employee FirstName:" + e4.getFirstName());
                }
                logger.log(System.Logger.Level.TRACE, "orderByTest4: Expected size received, check ordering . . .");
                Object[] result = resultsList.toArray(new String[resultsList.size()]);
                pass2 = Arrays.equals(expectedResult, result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderByTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "createTestData");
            this.getEntityTransaction().begin();
            float salary = 10000.0f;
            Department d1 = new Department(50, "SJSAS Appserver");
            this.getEntityManager().persist((Object)d1);
            Insurance s1 = new Insurance(60, "United");
            this.getEntityManager().persist((Object)s1);
            Employee e1 = new Employee(70, "Jie", "Leng", 10000.0f, d1, s1);
            Employee e2 = new Employee(80, "Zoe", "Leng", 10000.0f, d1, s1);
            Employee e3 = new Employee(90, "Song", "Leng", 10000.0f, d1, s1);
            Employee e4 = new Employee(65, "May", "Leng", 10000.0f, d1, s1);
            Employee e5 = new Employee(85, "Penelope", "Leng", 10000.0f);
            this.getEntityManager().persist((Object)e1);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().persist((Object)e3);
            this.getEntityManager().persist((Object)e4);
            this.getEntityManager().persist((Object)e5);
            ArrayList<Employee> link = new ArrayList<Employee>();
            link.add(e1);
            link.add(e2);
            link.add(e3);
            link.add(e4);
            d1.setEmployees(link);
            this.getEntityManager().merge((Object)d1);
            s1.setEmployees(link);
            this.getEntityManager().merge((Object)s1);
            logger.log(System.Logger.Level.TRACE, "persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from INSURANCE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

