/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.orderby;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.orderby.A;
import ee.jakarta.tck.persistence.core.annotations.orderby.A2;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address;
import ee.jakarta.tck.persistence.core.annotations.orderby.Address2;
import ee.jakarta.tck.persistence.core.annotations.orderby.ZipCode;
import ee.jakarta.tck.persistence.core.annotations.orderby.ZipCode2;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    List<Address> addrRef;
    Address addr1 = null;
    Address addr2 = null;
    Address addr3 = null;
    List<Address2> addrRef2;
    Address2 addr11 = null;
    Address2 addr12 = null;
    Address2 addr13 = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A", pkgName + "A2", pkgName + "Address", pkgName + "Address2", pkgName + "Customer", pkgName + "Customer2", pkgName + "Department", pkgName + "Employee", pkgName + "Insurance", pkgName + "ZipCode", pkgName + "ZipCode2"};
        return this.createDeploymentJar("jpa_core_annotations_orderby2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupAddress() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupAddress");
        try {
            super.setup();
            this.createDeployment();
            this.removeAddressData();
            this.createAddressData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void propertyDotNotationTest() throws Exception {
        boolean pass = false;
        try {
            this.addrRef = new ArrayList<Address>();
            ArrayList<Address> expected = new ArrayList<Address>();
            expected.add(this.addr2);
            expected.add(this.addr3);
            expected.add(this.addr1);
            this.clearCache();
            A a = (A)this.getEntityManager().find(A.class, (Object)"1");
            List<Address> actual = a.getAddressList();
            if (actual.size() == expected.size()) {
                int count = 0;
                for (int i = 0; i < expected.size(); ++i) {
                    logger.log(System.Logger.Level.TRACE, "Testing - expected[" + expected.get(i) + "], actual[" + actual.get(i) + "]");
                    if (!((Address)expected.get(i)).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == expected.size()) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "count=" + count + ", expected size:" + expected.size());
                    for (Address aa : expected) {
                        logger.log(System.Logger.Level.ERROR, "expected:" + aa);
                    }
                    logger.log(System.Logger.Level.ERROR, "------------");
                    for (Address aa : actual) {
                        logger.log(System.Logger.Level.ERROR, "actual:" + aa);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected list size:" + expected.size() + ", actual size:" + actual.size());
                for (Address aa : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + aa);
                }
                logger.log(System.Logger.Level.ERROR, "------------");
                for (Address aa : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + aa);
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("propertyDotNotationTest failed");
        }
    }

    @Test
    public void fieldDotNotationTest() throws Exception {
        boolean pass = false;
        try {
            this.addrRef = new ArrayList<Address>();
            ArrayList<Address2> expected = new ArrayList<Address2>();
            expected.add(this.addr12);
            expected.add(this.addr13);
            expected.add(this.addr11);
            logger.log(System.Logger.Level.TRACE, "Clearing the cache");
            this.clearCache();
            A2 a = (A2)this.getEntityManager().find(A2.class, (Object)"2");
            List<Address2> actual = a.getAddressList();
            if (actual.size() == expected.size()) {
                int count = 0;
                for (int i = 0; i < expected.size(); ++i) {
                    logger.log(System.Logger.Level.TRACE, "Testing - expected[" + expected.get(i) + "], actual[" + actual.get(i) + "]");
                    if (!((Address2)expected.get(i)).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == expected.size()) {
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.TRACE, "count=" + count + ", expected size:" + expected.size());
                    for (Address2 aa : expected) {
                        logger.log(System.Logger.Level.ERROR, "expected:" + aa);
                    }
                    logger.log(System.Logger.Level.ERROR, "------------");
                    for (Address2 aa : actual) {
                        logger.log(System.Logger.Level.ERROR, "actual:" + aa);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected list size:" + expected.size() + ", actual size:" + actual.size());
                for (Address2 aa : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + aa);
                }
                logger.log(System.Logger.Level.ERROR, "------------");
                for (Address2 aa : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + aa);
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("propertyDotNotationTest failed");
        }
    }

    private void createAddressData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "createAddressData");
            this.getEntityTransaction().begin();
            this.addr1 = new Address("1 Network Drive", "Burlington", "MA", new ZipCode("01801"));
            this.addr2 = new Address("634 Goldstar Road", "Peabody", "MA", new ZipCode("88444"));
            this.addr3 = new Address("3212 Boston Road", "Chelmsford", "MA", new ZipCode("01824"));
            this.addrRef = new ArrayList<Address>();
            this.addrRef.add(this.addr1);
            this.addrRef.add(this.addr2);
            this.addrRef.add(this.addr3);
            A a1 = new A("1", "b1", this.addrRef);
            this.addr11 = new Address2("1 Network Drive", "Burlington", "MA", new ZipCode2("01801"));
            this.addr12 = new Address2("634 Goldstar Road", "Peabody", "MA", new ZipCode2("88444"));
            this.addr13 = new Address2("3212 Boston Road", "Chelmsford", "MA", new ZipCode2("01824"));
            this.addrRef2 = new ArrayList<Address2>();
            this.addrRef2.add(this.addr11);
            this.addrRef2.add(this.addr12);
            this.addrRef2.add(this.addr13);
            A2 a2 = new A2("2", "b2", this.addrRef2);
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().persist((Object)a2);
            this.getEntityManager().flush();
            this.getEntityManager().refresh((Object)a1);
            this.getEntityManager().refresh((Object)a2);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanupAddress() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeAddressData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeAddressData() {
        logger.log(System.Logger.Level.TRACE, "removeAddressData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COLTAB_ADDRESS").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COLTAB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

