/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.HardwareProduct;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.UtilProductData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client6
extends UtilProductData {
    private static final System.Logger logger = System.getLogger(Client6.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client6.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        classes = Client6.concat((String[])this.getSchema30classes(), (String[])classes);
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaQuery6.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void typeTest() throws Exception {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (HardwareProduct p : this.hardwareRef) {
            expected.add(Integer.valueOf(p.getId()));
        }
        Collections.sort(expected);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Product.class);
            Root product = cquery.from(Product.class);
            cquery.where((Expression)cbuilder.and(new Predicate[]{cbuilder.equal(product.type(), HardwareProduct.class)}));
            cquery.select((Selection)product);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            for (Product p : result) {
                actual.add(Integer.parseInt(p.getId()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception queryTest47: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("typeTest failed");
        }
    }
}

