/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.metamodelquery;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Address_;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.Phone_;
import ee.jakarta.tck.persistence.common.schema30.UtilPhoneData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client6
extends UtilPhoneData {
    private static final System.Logger logger = System.getLogger(Client6.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client6.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_metamodelquery6.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupPhoneData")
    @Test
    public void queryTest55() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "determine which customers have an area code beginning with 9");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin p = customer.join(Customer_.home).join(Address_.phones);
            cquery.where((Expression)cbuilder.like((Expression)p.get(Phone_.area), (Expression)cbuilder.parameter(String.class, "area")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("area", (Object)"9%");
            tquery.setMaxResults(this.customerRef.length);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3", "12", "16"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 references, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest55 failed");
        }
    }
}

