/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.parameter;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.criteriaapi.parameter.Employee;
import java.sql.Date;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;

public abstract class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    Employee[] empRef = new Employee[5];
    final Date d1 = this.getSQLDate("2000-02-14");

    public abstract JavaArchive createDeployment() throws Exception;

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "calling super.cleanup");
            this.removeTestData();
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTestData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Employees");
            Date d2 = this.getSQLDate("2001-06-27");
            Date d3 = this.getSQLDate("2002-07-07");
            Date d4 = this.getSQLDate("2003-03-03");
            Date d5 = this.getSQLDate();
            this.empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            for (Employee e : this.empRef) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                logger.log(System.Logger.Level.TRACE, "persisted employee:" + e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    protected void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

