/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactoryCloseExceptions;

import com.sun.ts.lib.harness.CleanupMethod;
import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityManagerFactory;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    Properties props = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{};
        return this.createDeploymentJar("jpa_core_entityManagerFactoryCloseExceptions.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    public void nullCleanup() throws Exception {
    }

    @CleanupMethod(name="nullCleanup")
    @Test
    public void exceptionsTest() throws Exception {
        int passCount = 0;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        logger.log(System.Logger.Level.INFO, "Getting EntityManagerFactory");
        EntityManagerFactory emf = this.isStandAloneMode() ? this.getEntityManager().getEntityManagerFactory() : this.getEntityManagerFactory();
        if (emf != null) {
            if (emf.isOpen()) {
                logger.log(System.Logger.Level.INFO, "EMF is open, now closing it");
                emf.close();
            } else {
                logger.log(System.Logger.Level.INFO, "EMF is already closed");
            }
            logger.log(System.Logger.Level.INFO, "Testing getMetamodel() after close");
            try {
                emf.getMetamodel();
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing emf.getProperties()");
            try {
                emf.getProperties();
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing getPersistenceUnitUtil() after close");
            try {
                emf.getPersistenceUnitUtil();
                logger.log(System.Logger.Level.ERROR, "Did no throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
                ++passCount;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing close after close ");
            try {
                emf.close();
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing createEntityManager() after close");
            try {
                emf.createEntityManager();
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing createEntityManager(Map) after close");
            try {
                emf.createEntityManager(myMap);
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing getCache after close ");
            try {
                emf.getCache();
                logger.log(System.Logger.Level.ERROR, "IllegalStateException not thrown");
            }
            catch (IllegalStateException e) {
                logger.log(System.Logger.Level.TRACE, "IllegalStateException Caught as Expected.");
                ++passCount;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            try {
                emf.getCriteriaBuilder();
                logger.log(System.Logger.Level.ERROR, "IllegalStateException was not thrown");
            }
            catch (IllegalStateException ise) {
                ++passCount;
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalStateException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Could not obtain an EntityManagerFactory");
        }
        if (passCount != 8) {
            throw new Exception("exceptionsTest failed");
        }
    }
}

