/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.language;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.HardwareProduct;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct;
import ee.jakarta.tck.persistence.common.schema30.UtilProductData;
import ee.jakarta.tck.persistence.core.query.language.Client1;
import jakarta.persistence.Query;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client4
extends UtilProductData {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client1.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_query_language4.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest7() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find All Products");
            List p = this.getEntityManager().createQuery("Select DISTINCT Object(P) From Product p where P.quantity < 10").getResultList();
            String[] expectedPKs = new String[]{"15", "21"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest7 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest38() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing MOD with numeric Java object types");
            logger.log(System.Logger.Level.TRACE, "find orders that have the quantity of 50 available");
            Integer value1 = 550;
            Integer value2 = 100;
            List p = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where MOD(" + value1 + "," + value2 + ") = p.quantity").getResultList();
            String[] expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass1 = true;
            }
            logger.log(System.Logger.Level.INFO, "Testing MOD with primitive numeric type");
            logger.log(System.Logger.Level.TRACE, "find orders that have the quantity of 50 available");
            p = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where MOD(550, 100) = p.quantity").getResultList();
            expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest38 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest40() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute two queries composed differently and verify results Execute Query 1");
            List p1 = this.getEntityManager().createQuery("Select DISTINCT OBJECT(p) From Product p where p.quantity BETWEEN 10 AND 20").getResultList();
            String[] expectedPKs = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            logger.log(System.Logger.Level.TRACE, "Execute Query 2");
            List p2 = this.getEntityManager().createQuery("Select DISTINCT OBJECT(p) From Product p where (p.quantity >= 10) AND (p.quantity <= 20)").getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            if (!this.checkEntityPK(p1, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for first query in queryTest40.   Expected 7 references, got: " + p1.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for first query in queryTest40.");
                pass1 = true;
            }
            if (!this.checkEntityPK(p2, expectedPKs2)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for second query in queryTest40.   Expected 7 references, got: " + p2.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for second query in queryTest40.");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest40 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest41() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Execute two queries composed differently and verify results Execute first query");
            List p1 = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where p.quantity NOT BETWEEN 20 AND 200").getResultList();
            String[] expectedPKs = new String[]{"8", "9", "10", "11", "14", "15", "17", "21", "29", "31"};
            if (!this.checkEntityPK(p1, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for first query.  Expected 31 references, got: " + p1.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for first query");
                pass1 = true;
            }
            logger.log(System.Logger.Level.TRACE, "Execute second query");
            List p2 = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where (p.quantity < 20) OR (p.quantity > 200)").getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "10", "11", "14", "15", "17", "21", "29", "31"};
            if (!this.checkEntityPK(p2, expectedPKs2)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for second query.  Expected 31 references, got: " + p2.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest41 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest43() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Check results of AND operator: False AND False = False");
            List p = this.getEntityManager().createQuery("Select Distinct Object(p) from Product p where (p.quantity > (500 + :int1)) AND (p.partNumber IS NULL)").setParameter("int1", (Object)100).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest43 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest44() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "provide a null value for a comparison operation and verify the results");
            List p = this.getEntityManager().createQuery("Select Distinct Object(p) from Product p where p.name = ?1").setParameter(1, null).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 0 references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest44 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest68() throws Exception {
        boolean pass = false;
        Double d1 = 33387.14;
        Double d2 = 33387.15;
        try {
            logger.log(System.Logger.Level.TRACE, "find SUM of all product prices");
            Query q = this.getEntityManager().createQuery("SELECT Sum(p.price) FROM Product p");
            Double d3 = (Double)q.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                logger.log(System.Logger.Level.TRACE, "Returned expected results: " + d1);
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "Returned " + d3 + "expected: " + d1);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest68 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void queryTest70() throws Exception {
        boolean pass = false;
        Long expectedValue = 3277L;
        try {
            logger.log(System.Logger.Level.TRACE, "find SUM of all product prices");
            Query q = this.getEntityManager().createQuery("SELECT Sum(p.quantity) FROM Product p");
            Long result = (Long)q.getSingleResult();
            if (expectedValue.equals(result)) {
                logger.log(System.Logger.Level.TRACE, "Returned expected results: " + result);
                pass = true;
            } else {
                logger.log(System.Logger.Level.TRACE, "Returned " + result + "expected: " + expectedValue);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception queryTest70: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("queryTest70 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void test_betweenDates() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Date date1 = this.getSQLDate(2000, 2, 14);
            Date date6 = this.getSQLDate(2005, 2, 18);
            logger.log(System.Logger.Level.TRACE, "The dates used in test_betweenDates is : " + date1 + " and " + date6);
            List result = this.getEntityManager().createQuery("SELECT DISTINCT p From Product p where p.shelfLife.soldDate BETWEEN :date1 AND :date6").setParameter("date1", (Object)date1).setParameter("date6", (Object)date6).getResultList();
            String[] expectedPKs = new String[]{"31", "32", "33", "37"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 3 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_betweenDates failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void test_notBetweenDates() throws Exception {
        boolean pass = false;
        Date date1 = this.getSQLDate("2000-02-14");
        Date newdate = this.getSQLDate("2005-02-17");
        logger.log(System.Logger.Level.TRACE, "The dates used in test_betweenDates is : " + date1 + " and " + newdate);
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT p From Product p where p.shelfLife.soldDate NOT BETWEEN :date1 AND :newdate").setParameter("date1", (Object)date1).setParameter("newdate", (Object)newdate).getResultList();
            String[] expectedPKs = new String[]{"31"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test_notBetweenDates failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void aggregateFunctionsWithNoValuesTest() throws Exception {
        Object o;
        Query q;
        boolean pass = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing SUM");
            logger.log(System.Logger.Level.TRACE, "find SUM of all product prices");
            q = this.getEntityManager().createQuery("SELECT Sum(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                logger.log(System.Logger.Level.TRACE, "Returned expected null results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing AVG");
            logger.log(System.Logger.Level.TRACE, "find AVG of all product prices");
            q = this.getEntityManager().createQuery("SELECT AVG(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                logger.log(System.Logger.Level.TRACE, "Returned expected null results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing MAX");
            logger.log(System.Logger.Level.TRACE, "find MAX of all product prices");
            q = this.getEntityManager().createQuery("SELECT MAX(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                logger.log(System.Logger.Level.TRACE, "Returned expected null results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing MIN");
            logger.log(System.Logger.Level.TRACE, "find MIN of all product prices");
            q = this.getEntityManager().createQuery("SELECT MIN(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                logger.log(System.Logger.Level.TRACE, "Returned expected null results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing COUNT");
            logger.log(System.Logger.Level.TRACE, "find COUNT of all product prices");
            q = this.getEntityManager().createQuery("SELECT COUNT(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o != null) {
                if (o instanceof Long) {
                    Long i = (Long)o;
                    if (i == 0L) {
                        logger.log(System.Logger.Level.TRACE, "Returned expected 0 result");
                        pass = true;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get instance of Long");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Received null instead of 0");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("aggregateFunctionsWithNoValuesTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void primaryKeyJoinColumnTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("Select p from Product p where p.wareHouse = 'WH5'").getResultList();
            if (actual.size() == 1 && ((Product)actual.get(0)).getWareHouse().equals("WH5")) {
                logger.log(System.Logger.Level.TRACE, "Expected results received:" + ((Product)actual.get(0)).getWareHouse());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "test returned: " + ((Product)actual.get(0)).getWareHouse() + ", expected: WH5");
                for (Product p : actual) {
                    logger.log(System.Logger.Level.ERROR, "**id=" + p.getId() + ", model=" + p.getWareHouse());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void typeTest() throws Exception {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (HardwareProduct p : this.hardwareRef) {
            expected.add(Integer.valueOf(p.getId()));
        }
        Collections.sort(expected);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        this.getEntityTransaction().begin();
        List result = this.getEntityManager().createQuery("Select p from Product p where TYPE(p) = HardwareProduct").getResultList();
        for (HardwareProduct p : result) {
            actual.add(Integer.parseInt(p.getId()));
        }
        Collections.sort(actual);
        if (!this.checkEntityPK(actual, expected)) {
            logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
        } else {
            logger.log(System.Logger.Level.TRACE, "Expected results received");
            pass = true;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void entityTypeLiteralTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find All Products");
            List p = this.getEntityManager().createQuery("Select p From Product p where TYPE(p) in (SoftwareProduct)").getResultList();
            String[] expectedPKs = new String[this.softwareRef.length];
            int i = 0;
            for (SoftwareProduct sf : this.softwareRef) {
                expectedPKs[i++] = sf.getId();
            }
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("entityTypeLiteralTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    @Test
    public void scalarExpressionsTest() throws Exception {
        String[] expectedPKs;
        List p;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select p From Product p where ((p.quantity) + 10 < 25)").getResultList();
            expectedPKs = new String[]{"8", "9", "15", "17", "21"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Testing string expression:");
            p = this.getEntityManager().createQuery("Select p From Product p where (p.name like 'Java%')").getResultList();
            expectedPKs = new String[]{"1", "2", "20", "34"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("scalarExpressionsTest failed");
        }
    }
}

