/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.generator;

import ee.jakarta.tck.persistence.core.types.generator.Client;
import ee.jakarta.tck.persistence.core.types.generator.DataTypes3;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client3
extends Client {
    private static final System.Logger logger = System.getLogger(Client3.class.getName());
    private DataTypes3 d11;
    private boolean supports_sequence = false;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client3.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DataTypes", pkgName + "DataTypes2", pkgName + "DataTypes3", pkgName + "DataTypes4"};
        return this.createDeploymentJar("jpa_core_types_generator3.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupDataTypes3() throws Exception {
        block4: {
            logger.log(System.Logger.Level.TRACE, "setupDataTypes3");
            try {
                super.setup();
                this.createDeployment();
                String s = System.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    logger.log(System.Logger.Level.INFO, "db.supports.sequence:" + this.supports_sequence);
                    if (this.supports_sequence) {
                        this.createSequenceGenerator();
                        this.removeTestData();
                        this.createDataTypes3Data();
                    }
                    break block4;
                }
                logger.log(System.Logger.Level.ERROR, "The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new Exception("setupDataTypes3 failed");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
                throw new Exception("setupDataTypes3 failed:", e);
            }
        }
    }

    @Test
    public void sequenceGeneratorOnEntityTest() throws Exception {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Integer newInt = 1000;
                try {
                    this.getEntityTransaction().begin();
                    this.clearCache();
                    logger.log(System.Logger.Level.INFO, "Doing a find of id: " + this.d11.getId());
                    DataTypes3 d = (DataTypes3)this.getEntityManager().find(DataTypes3.class, (Object)this.d11.getId());
                    if (d != null) {
                        Integer i = d.getIntegerData();
                        if (i.equals(this.d11.getIntegerData())) {
                            logger.log(System.Logger.Level.TRACE, "find returned correct Integer value:" + i);
                            d.setIntegerData(newInt);
                        } else {
                            logger.log(System.Logger.Level.ERROR, "find did not return correct Integer value, expected: " + this.d11.getIntegerData() + ", actual:" + i);
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        this.clearCache();
                        logger.log(System.Logger.Level.INFO, "Doing a find of merged data for id: " + d.getId());
                        DataTypes3 d2 = (DataTypes3)this.getEntityManager().find(DataTypes3.class, (Object)d.getId());
                        i = d2.getIntegerData();
                        if (i.equals(d2.getIntegerData())) {
                            logger.log(System.Logger.Level.TRACE, "find returned correct merged Integer value:" + i);
                        } else {
                            logger.log(System.Logger.Level.ERROR, "find did not return correct Integer value, expected: " + d.getIntegerData() + ", actual:" + i);
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    logger.log(System.Logger.Level.ERROR, "find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.INFO, "WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new Exception("sequenceGeneratorOnEntityTest failed");
        }
    }

    public void createDataTypes3Data() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "in createDataTypes3Data");
            logger.log(System.Logger.Level.TRACE, "new DataType3");
            this.d11 = new DataTypes3(500);
            logger.log(System.Logger.Level.TRACE, "Persist DataType3");
            this.getEntityManager().persist((Object)this.d11);
            logger.log(System.Logger.Level.TRACE, "DataType3 id:" + this.d11.getId());
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
    }
}

