/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph.Department;
import ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph.Employee2;
import ee.jakarta.tck.persistence.jpa22.repeatable.namedentitygraph.Employee3;
import jakarta.persistence.EntityGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final long serialVersionUID = 22L;
    Employee3[] empRef = new Employee3[5];
    Department[] deptRef = new Department[2];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Employee", pkgName + "Employee2", pkgName + "Employee3"};
        return this.createDeploymentJar("jpa_jpa22_repeatable_namedentitygraph.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupEmployeeData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupOrderData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createEmployeeData();
            this.displayMap(new Properties());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupEmployeeData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            this.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void entityGraphGetNameNoNameExistsTest() throws Exception {
        boolean pass = false;
        List egs = this.getEntityManager().getEntityGraphs(Employee2.class);
        if (egs.size() == 1) {
            EntityGraph e = (EntityGraph)egs.get(0);
            if (e.getName().equals("Employee2")) {
                logger.log(System.Logger.Level.TRACE, "Received expected name:" + e.getName());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected name: Employee2, actual:" + e.getName());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected 1 graph to be returned, instead got:" + egs.size());
        }
        if (!pass) {
            throw new Exception("entityGraphGetNameNoNameExistsTest failed");
        }
    }

    @Test
    public void getNameTest() throws Exception {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee2.class);
        if (eg.getName() == null) {
            logger.log(System.Logger.Level.TRACE, "Received expected null");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected name: null, actual:" + eg.getName());
        }
        if (!pass) {
            throw new Exception("getNameTest failed");
        }
    }

    @Test
    public void getEntityGraphsClassTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("first_last_graph");
        expected.add("last_salary_graph");
        expected.add("lastname_department_subgraphs");
        ArrayList<String> actual = new ArrayList<String>();
        List eg = this.getEntityManager().getEntityGraphs(Employee3.class);
        if (eg.size() > 0) {
            for (EntityGraph e : eg) {
                actual.add(e.getName());
            }
            if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected results");
                for (String s : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + s);
                }
                logger.log(System.Logger.Level.ERROR, "Actual results");
                for (String s : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + s);
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "No named entity graphs were returned eventhough they exist in entity");
        }
        if (!pass) {
            throw new Exception("getEntityGraphsClassTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.deptRef[0] = new Department(1, "Marketing");
            this.deptRef[1] = new Department(2, "Administration");
            for (Department department : this.deptRef) {
                this.getEntityManager().persist((Object)department);
                logger.log(System.Logger.Level.TRACE, "persisted department:" + department);
            }
            this.empRef[0] = new Employee3(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[1] = new Employee3(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[0]);
            this.empRef[2] = new Employee3(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[1]);
            this.empRef[3] = new Employee3(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[1]);
            this.empRef[4] = new Employee3(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[1]);
            for (Serializable serializable : this.empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "persisted employee3:" + (Employee3)serializable);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

