/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.common;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.javamail.ee.common.MailAuthenticator;
import jakarta.mail.Authenticator;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class MailTestUtil {
    public String testname;
    public String protocol;
    public String transport_protocol;
    public String host;
    public String transport_host;
    public String user;
    public String password;
    public boolean auth;
    public String mailbox;
    public String testbox;
    public String from;
    public String to;
    public String rootpath = "";
    public String pattern;
    public String iofile;
    public String newName;
    public String subject;
    public String portvalue;
    public String workdir;
    public String proxy;
    public int msgcount = -1;
    public int portnum = -1;
    public int errors = 0;
    public Status status;
    public Properties properties = new Properties();
    public PrintWriter out;
    public PrintWriter log;
    public Session session;
    public boolean debug = false;

    public void parseArgs(String[] argv) {
        int optind;
        for (optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-t")) {
                this.protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-tp")) {
                this.transport_protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-th")) {
                this.transport_host = MailTestUtil.ifnull(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-h")) {
                this.host = MailTestUtil.ifnull(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-u")) {
                this.user = MailTestUtil.ifnull(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-p")) {
                this.password = MailTestUtil.ifnull(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-m")) {
                this.mailbox = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-test")) {
                this.testbox = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-from")) {
                this.from = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-to")) {
                this.to = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-r")) {
                this.rootpath = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-io")) {
                this.iofile = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-s")) {
                this.pattern = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-n")) {
                this.newName = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-subject")) {
                this.subject = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-pn")) {
                this.portvalue = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-WorkDir")) {
                this.workdir = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-A")) {
                this.auth = true;
                continue;
            }
            if (argv[optind].equals("-proxy")) {
                this.proxy = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-D")) {
                this.debug = true;
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            this.out.println("Usage: test [-D] [-t protocol] [-tp transport_protocol] [-th transport_host]");
            this.out.println("\t[-h host] [-u user] [-p password] [-r rootpath] [-m mailbox]");
            this.out.println("\t[-test testbox] [-from from_address] [-to to_address] [-io iofile]");
            this.out.println("\t[-s pattern] [-n newname] [-subject subject] [-pn port_number]");
            this.out.println("\t[-WorkDir workdirpath] [-A] [-proxy socks-proxy] [msgcount]");
            System.exit(1);
        }
        if (optind < argv.length) {
            this.msgcount = Integer.parseInt(argv[optind]);
        }
        if (this.portvalue != null) {
            this.portnum = Integer.parseInt(this.portvalue);
        }
        if (this.transport_host == null) {
            this.transport_host = this.host;
        }
        if (this.protocol != null) {
            this.properties.setProperty("mail.store.protocol", this.protocol);
            if (this.host != null) {
                this.properties.setProperty("mail." + this.protocol + ".host", this.host);
            }
            if (this.user != null) {
                this.properties.setProperty("mail." + this.protocol + ".user", this.user);
            }
            if (this.portnum > 0) {
                this.properties.setProperty("mail." + this.protocol + ".port", "" + this.portnum);
            }
            if (this.proxy != null) {
                this.properties.setProperty("mail." + this.protocol + ".socks.host", this.proxy);
            }
        }
        if (this.transport_protocol != null) {
            this.properties.setProperty("mail.transport.protocol", this.transport_protocol);
            if (this.transport_host != null) {
                this.properties.setProperty("mail." + this.transport_protocol + ".host", this.transport_host);
            }
            if (this.user != null) {
                this.properties.setProperty("mail." + this.transport_protocol + ".user", this.user);
            }
            this.properties.setProperty("mail." + this.transport_protocol + ".auth", "" + this.auth);
            if (this.proxy != null) {
                this.properties.setProperty("mail." + this.transport_protocol + ".socks.host", this.proxy);
            }
        }
    }

    private static String ifnull(String arg) {
        return arg.equals("NULL") ? null : arg;
    }

    public Session createSession() {
        final String user0 = this.user;
        final String password0 = this.password;
        Session session = Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user0, password0);
            }
        });
        session.setDebug(this.debug);
        return session;
    }

    public Store connect2host(String proto, String host, String user, String password) {
        Store store = null;
        try {
            this.session = this.createSession();
            this.session.setDebug(this.debug);
            if (this.debug) {
                this.out.println("Password is:" + password);
                this.out.println("User is:" + user);
                this.out.println("Host:" + host);
                this.out.println("Port:" + this.portnum);
                this.out.println("Protocol:" + proto);
            }
            if (this.session == null) {
                this.out.println("Warning: Failed to create a Session object!");
                return null;
            }
            store = this.session.getStore(proto);
            if (store == null) {
                this.out.println("Warning: Failed to create a Store object!");
                return null;
            }
            if (host != null || user != null || password != null) {
                if (this.portnum > 0) {
                    store.connect(host, this.portnum, user, password);
                } else {
                    store.connect(host, user, password);
                }
            } else {
                store.connect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return store;
    }

    public Store connect2host(String proto, String host, String user, String password, Session session) {
        Store store = null;
        try {
            store = session.getStore(proto);
            if (store == null) {
                TestUtil.logMsg((String)"Warning: Failed to create a Store object!");
                return null;
            }
            int portnum = -1;
            if (host != null || user != null || password != null) {
                if (portnum > 0) {
                    store.connect(host, portnum, user, password);
                } else {
                    store.connect(host, user, password);
                }
            } else {
                store.connect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return store;
    }

    public Store connect2host(String proto, String host, int portnum, String user, String password) {
        Store store = null;
        try {
            this.session = this.createSession(host, String.valueOf(portnum), user, password);
            store = this.session.getStore(proto);
            if (store == null) {
                TestUtil.logMsg((String)"Warning: Failed to create a Store object!");
                return null;
            }
            if (host != null || user != null || password != null) {
                if (portnum > 0) {
                    store.connect(host, portnum, user, password);
                } else {
                    store.connect(host, user, password);
                }
            } else {
                store.connect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return store;
    }

    public Folder getRootFolder(Store store) {
        Folder folder = null;
        try {
            folder = this.rootpath.equals("") ? store.getDefaultFolder() : store.getFolder(this.rootpath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folder;
    }

    public Status checkMem() {
        Runtime rt = Runtime.getRuntime();
        this.out.println("Free Memory = " + rt.freeMemory());
        this.out.println("Test Aborted!");
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
        return this.status;
    }

    public ByteArrayInputStream createInputStream(Message msg) {
        ByteArrayInputStream bis = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (bos == null) {
                this.out.println("Warning: Failed to create a ByteArrayOutputStream object!");
                return null;
            }
            msg.writeTo((OutputStream)bos);
            bis = new ByteArrayInputStream(bos.toByteArray());
            if (bis == null) {
                this.out.println("Warning: Failed to create a ByteArrayInputStream object!");
                return null;
            }
        }
        catch (Exception e) {
            this.handlException(e);
        }
        return bis;
    }

    public void checkStatus() {
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
    }

    public Session getSession() {
        return this.session;
    }

    public void handlException(Exception e) {
        this.out.println("\nException caught!");
        this.status = Status.failed((String)"EXCEPTION");
        e.printStackTrace();
    }

    public void ExceptionTest(Exception e) {
        this.out.println("\nException caught!");
        this.status = Status.passed((String)"OKAY");
        e.printStackTrace();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Session createSession(String host, String user, String password) {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.submitter", user);
        properties.setProperty("mail.smtp.auth", "true");
        properties.setProperty("mail.smtp.host", host);
        properties.setProperty("mail.smtp.port", "25");
        MailAuthenticator mailAuthenticator = new MailAuthenticator(user, password);
        Session session = Session.getInstance((Properties)properties, (Authenticator)mailAuthenticator);
        return session;
    }

    public Session createSession(String host, String port, String user, String password) {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.submitter", user);
        properties.setProperty("mail.smtp.auth", "true");
        properties.setProperty("mail.smtp.host", host);
        properties.setProperty("mail.smtp.port", port);
        MailAuthenticator mailAuthenticator = new MailAuthenticator(user, password);
        Session session = Session.getInstance((Properties)properties, (Authenticator)mailAuthenticator);
        return session;
    }
}

